/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;

public class BandChangeUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignBand oldBand = null;
    private JRDesignBand newBand = null;
    private JRDesignElement element = null;
    private JasperDesign jasperDesign = null;

    public BandChangeUndoableEdit(JasperDesign jasperDesign, JRDesignBand oldBand, JRDesignBand newBand, JRDesignElement element) {
        this.oldBand = oldBand;
        this.newBand = newBand;
        this.element = element;
        this.jasperDesign = jasperDesign;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (this.oldBand != null && this.newBand != this.oldBand) {
            int y1 = ModelUtils.getBandLocation((JRBand)this.newBand, this.getJasperDesign());
            int y0 = ModelUtils.getBandLocation((JRBand)this.oldBand, this.getJasperDesign());
            int deltaBand = y0 - y1;
            this.newBand.getChildren().remove(this.getElement());
            this.getElement().setElementGroup((JRElementGroup)this.oldBand);
            this.getElement().setY(this.getElement().getY() - deltaBand);
            this.oldBand.getChildren().add(this.getElement());
            this.newBand.getEventSupport().firePropertyChange("children", null, null);
            this.oldBand.getEventSupport().firePropertyChange("children", null, null);
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (this.newBand != null && this.newBand != this.oldBand) {
            int y1 = ModelUtils.getBandLocation((JRBand)this.newBand, this.getJasperDesign());
            int y0 = ModelUtils.getBandLocation((JRBand)this.oldBand, this.getJasperDesign());
            int deltaBand = y0 - y1;
            this.oldBand.getChildren().remove(this.getElement());
            this.getElement().setElementGroup((JRElementGroup)this.newBand);
            this.getElement().setY(this.getElement().getY() + deltaBand);
            this.newBand.getChildren().add(this.getElement());
            this.newBand.getEventSupport().firePropertyChange("children", null, null);
            this.oldBand.getEventSupport().firePropertyChange("children", null, null);
        }
    }

    public String getPresentationName() {
        return "Element band change";
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public JRDesignBand getOldBand() {
        return this.oldBand;
    }

    public void setOldBand(JRDesignBand oldBand) {
        this.oldBand = oldBand;
    }

    public JRDesignBand getNewBand() {
        return this.newBand;
    }

    public void setNewBand(JRDesignBand newBand) {
        this.newBand = newBand;
    }

    public JRDesignElement getElement() {
        return this.element;
    }

    public void setElement(JRDesignElement element) {
        this.element = element;
    }
}

