/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.editors.JRTabStopsPropertyEditor;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import org.openide.nodes.PropertySupport;

public class TabStopsProperty
extends PropertySupport {
    PropertyEditor editor = null;
    private JRBaseStyle style = null;

    public TabStopsProperty(JRBaseStyle style) {
        super("tabStops", List.class, I18n.getString("Global.Property.TabStops"), I18n.getString("Global.Property.TabStops.desc"), true, true);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.setValue("useList", Boolean.TRUE);
        this.style = style;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        TabStop[] tabStops = this.style.getParagraph().getTabStops();
        ArrayList<TabStop> tabStopsList = new ArrayList<TabStop>();
        if (tabStops != null) {
            tabStopsList.addAll(Arrays.asList(tabStops));
        }
        return tabStopsList;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!(val instanceof List)) {
            throw new IllegalArgumentException();
        }
        List values = (List)val;
        if (this.style.getParagraph().getTabStops() != null) {
            for (int k = this.style.getParagraph().getTabStops().length - 1; k >= 0; --k) {
                this.style.getParagraph().removeTabStop(0);
            }
        }
        for (int i = 0; i < values.size(); ++i) {
            TabStop prop = (TabStop)values.get(i);
            this.style.getParagraph().addTabStop(prop);
        }
        IReportManager.getInstance().notifyReportChange();
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRTabStopsPropertyEditor();
        }
        return this.editor;
    }
}

