/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.sheet.properties.FloatProperty;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.type.LineSpacingEnum;

public class LineSpacingSizeProperty
extends FloatProperty {
    private JRBaseStyle style = null;

    public LineSpacingSizeProperty(JRBaseStyle style) {
        super(style);
        this.style = style;
    }

    public String getName() {
        return "lineSpacingSize";
    }

    public String getDisplayName() {
        return I18n.getString("Global.Property.LineSpacingSize");
    }

    public String getShortDescription() {
        return I18n.getString("Global.Property.LineSpacingSize.desc");
    }

    public Float getFloat() {
        return this.style.getParagraph().getLineSpacingSize() == null ? new Float(0.0f) : this.style.getParagraph().getLineSpacingSize();
    }

    public Float getOwnFloat() {
        return this.style.getParagraph().getOwnLineSpacingSize() == null ? new Float(0.0f) : this.style.getParagraph().getOwnLineSpacingSize();
    }

    public Float getDefaultFloat() {
        return new Float(0.0f);
    }

    public void setFloat(Float num) {
        if (num == null || num.intValue() == 0) {
            this.style.getParagraph().setLineSpacingSize(null);
        } else {
            this.style.getParagraph().setLineSpacingSize(num);
        }
    }

    public void validateFloat(Float value) {
    }

    public boolean canWrite() {
        LineSpacingEnum val = this.style.getParagraph().getLineSpacing();
        return val != null && val != LineSpacingEnum.DOUBLE && val != LineSpacingEnum.ONE_AND_HALF && val != LineSpacingEnum.SINGLE;
    }
}

