/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.type.ScaleTypeEnum;
import org.openide.nodes.PropertySupport;

public final class BubbleScaleTypeProperty
extends PropertySupport {
    private final JRDesignBubblePlot element;
    private ComboBoxPropertyEditor editor;

    public BubbleScaleTypeProperty(JRDesignBubblePlot element) {
        super("scaleType", ScaleTypeEnum.class, I18n.getString("Global.Property.ScaleType"), I18n.getString("Global.Property.ScaleType"), true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(ScaleTypeEnum.ON_BOTH_AXES, I18n.getString("Global.Property.BothAxes")));
            l.add(new Tag(ScaleTypeEnum.ON_DOMAIN_AXIS, I18n.getString("Global.Property.DomainAxis")));
            l.add(new Tag(ScaleTypeEnum.ON_RANGE_AXIS, I18n.getString("Global.Property.RangeAxis")));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getScaleTypeValue();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val instanceof ScaleTypeEnum) {
            ScaleTypeEnum oldValue = this.element.getScaleTypeValue();
            ScaleTypeEnum newValue = (ScaleTypeEnum)val;
            this.element.setScaleType(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "ScaleType", ScaleTypeEnum.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getScaleTypeValue() == ScaleTypeEnum.ON_RANGE_AXIS;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(ScaleTypeEnum.ON_RANGE_AXIS);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

