/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.editors.JRTabStopsPropertyEditor;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import org.openide.nodes.PropertySupport;

public class TabStopsProperty
extends PropertySupport {
    PropertyEditor editor = null;
    JRDesignTextElement element = null;

    public TabStopsProperty(JRDesignTextElement element) {
        super("tabStops", List.class, I18n.getString("Global.Property.TabStops"), I18n.getString("Global.Property.TabStops.desc"), true, true);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.setValue("useList", Boolean.TRUE);
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        TabStop[] tabStops = this.element.getParagraph().getTabStops();
        ArrayList<TabStop> tabStopsList = new ArrayList<TabStop>();
        if (tabStops != null) {
            tabStopsList.addAll(Arrays.asList(tabStops));
        }
        return tabStopsList;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!(val instanceof List)) {
            throw new IllegalArgumentException();
        }
        List values = (List)val;
        if (this.element.getParagraph().getTabStops() != null) {
            for (int k = this.element.getParagraph().getTabStops().length - 1; k >= 0; --k) {
                this.element.getParagraph().removeTabStop(0);
            }
        }
        for (int i = 0; i < values.size(); ++i) {
            TabStop prop = (TabStop)values.get(i);
            this.element.getParagraph().addTabStop(prop);
        }
        IReportManager.getInstance().notifyReportChange();
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRTabStopsPropertyEditor();
        }
        return this.editor;
    }

    public boolean supportsDefaultValue() {
        return false;
    }
}

