/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.JRImportsPropertyCustomEditor;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class JRImportsPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return false;
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return I18n.getString("JRImportsPropertyEditor.Property.NoImportsSet");
        }
        if (val.getClass().isArray() && val.getClass().getComponentType().equals(String.class)) {
            int len = ((String[])val).length;
            switch (len) {
                case 0: {
                    return I18n.getString("JRImportsPropertyEditor.Property.NoImportsSet");
                }
                case 1: {
                    return I18n.getString("JRImportsPropertyEditor.Property.OneImportSet");
                }
            }
            return I18n.getString("JRImportsPropertyEditor.Property.ImportsSet", len);
        }
        return "";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object val = this.getValue();
        return new JRImportsPropertyCustomEditor(val, this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
        this.env = env;
    }
}

