/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.JRImportDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class JRImportsPropertyCustomEditor
extends JPanel
implements PropertyChangeListener {
    private PropertyEnv env;
    private PropertyEditor editor;
    private JButton jButtonDeleteProperty;
    private JButton jButtonModifyProperty;
    private JButton jButtonNewProperty;
    private JPanel jPanel1;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JTable jTableProperties;

    public JRImportsPropertyCustomEditor(Object value, PropertyEditor editor, PropertyEnv env) {
        this.env = env;
        this.editor = editor;
        this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this.env.addPropertyChangeListener((PropertyChangeListener)this);
        this.initComponents();
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableProperties.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JRImportsPropertyCustomEditor.this.jTablePropertiesListSelectionValueChanged(e);
            }
        });
        if (value != null && value.getClass().isArray() && value.getClass().getComponentType().equals(String.class)) {
            this.setImports((String[])value);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableProperties = new JTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewProperty = new JButton();
        this.jButtonModifyProperty = new JButton();
        this.jButtonDeleteProperty = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jScrollPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JRImportsPropertyCustomEditor.this.jScrollPane3MouseClicked(evt);
            }
        });
        this.jTableProperties.setModel(new DefaultTableModel(new Object[0][], new String[]{"Import"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableProperties.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JRImportsPropertyCustomEditor.this.jTablePropertiesMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableProperties);
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons2.setPreferredSize(new Dimension(100, 100));
        this.jPanelButtons2.setLayout(new GridBagLayout());
        this.jButtonNewProperty.setText(NbBundle.getMessage(JRImportsPropertyCustomEditor.class, (String)"JRImportsPropertyCustomEditor.jButtonNewProperty.text"));
        this.jButtonNewProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRImportsPropertyCustomEditor.this.jButtonNewPropertyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonNewProperty, gridBagConstraints);
        this.jButtonModifyProperty.setText(NbBundle.getMessage(JRImportsPropertyCustomEditor.class, (String)"JRImportsPropertyCustomEditor.jButtonModifyProperty.text"));
        this.jButtonModifyProperty.setEnabled(false);
        this.jButtonModifyProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRImportsPropertyCustomEditor.this.jButtonModifyPropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        this.jPanelButtons2.add((Component)this.jButtonModifyProperty, gridBagConstraints);
        this.jButtonDeleteProperty.setText(NbBundle.getMessage(JRImportsPropertyCustomEditor.class, (String)"JRImportsPropertyCustomEditor.jButtonDeleteProperty.text"));
        this.jButtonDeleteProperty.setEnabled(false);
        this.jButtonDeleteProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRImportsPropertyCustomEditor.this.jButtonDeletePropertyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelButtons2.add((Component)this.jButtonDeleteProperty, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanelButtons2.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanelButtons2, "East");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 440, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jPanelFields, -1, 432, Short.MAX_VALUE).add(4, 4, 4))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 344, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jPanelFields, -1, 336, Short.MAX_VALUE).add(4, 4, 4))));
    }

    private void jTablePropertiesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1 && this.jTableProperties.getSelectedRow() >= 0) {
            this.jButtonModifyPropertyActionPerformed(new ActionEvent(this.jButtonModifyProperty, 0, ""));
        }
    }

    private void jScrollPane3MouseClicked(MouseEvent evt) {
    }

    private void jButtonNewPropertyActionPerformed(ActionEvent evt) {
        Window pWin = SwingUtilities.windowForComponent(this);
        JRImportDialog jrpd = new JRImportDialog(Misc.getMainFrame(), true);
        jrpd.setImports(this.getImports());
        jrpd.setVisible(true);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        if (jrpd.getDialogResult() == 0) {
            String val = jrpd.getImport();
            dtm.addRow(new Object[]{val});
            this.jTableProperties.updateUI();
        }
    }

    private void jButtonModifyPropertyActionPerformed(ActionEvent evt) {
        int index = this.jTableProperties.getSelectedRow();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        Window pWin = SwingUtilities.windowForComponent(this);
        JRImportDialog jrpd = new JRImportDialog(Misc.getMainFrame(), true);
        jrpd.setImports(this.getImports());
        jrpd.setImport("" + dtm.getValueAt(index, 0));
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            String val = jrpd.getImport();
            dtm.setValueAt(val, index, 0);
            this.jTableProperties.updateUI();
        }
    }

    private void jButtonDeletePropertyActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableProperties.getSelectedRows();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = rows.length - 1; i >= 0; --i) {
            dtm.removeRow(rows[i]);
        }
    }

    public void setImports(String[] imports) {
        DefaultTableModel model = (DefaultTableModel)this.jTableProperties.getModel();
        for (int i = 0; i < imports.length; ++i) {
            model.addRow(new Object[]{imports[i]});
        }
    }

    public String[] getImports() {
        DefaultTableModel model = (DefaultTableModel)this.jTableProperties.getModel();
        String[] imports = new String[model.getRowCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            imports[i] = "" + model.getValueAt(i, 0);
        }
        return imports;
    }

    private Object getPropertyValue() throws IllegalStateException {
        return this.getImports();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public void jTablePropertiesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableProperties.getSelectedRowCount() > 0) {
            this.jButtonModifyProperty.setEnabled(true);
            this.jButtonDeleteProperty.setEnabled(true);
        } else {
            this.jButtonModifyProperty.setEnabled(false);
            this.jButtonDeleteProperty.setEnabled(false);
        }
    }
}

