/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IRLocalJasperReportsContext;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class DefaultCellElementsLayout {
    private static DefaultCellElementsLayout instance;

    public static DefaultCellElementsLayout getInstance() {
        if (instance == null) {
            instance = new DefaultCellElementsLayout();
        }
        return instance;
    }

    public static void doLayout(final JRDesignCellContents cell, final CrosstabObjectScene scene) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultCellElementsLayout.getInstance().organizeCellElements(cell, scene);
            }
        });
    }

    private void organizeCellElements(JRDesignCellContents cell, CrosstabObjectScene sc) {
        int cW = cell.getWidth();
        int cH = cell.getHeight();
        List children = cell.getChildren();
        boolean y = false;
        if (children.size() == 0) {
            return;
        }
        int h = cH / children.size();
        SceneAnimator animator = new SceneAnimator((Scene)sc);
        CellAnimatorListener listener = new CellAnimatorListener();
        animator.getPreferredBoundsAnimator().addAnimatorListener((AnimatorListener)listener);
        animator.getPreferredLocationAnimator().addAnimatorListener((AnimatorListener)listener);
        listener.addAnimation();
        listener.addAnimation();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JRDesignElement)) continue;
            JRDesignElement element = (JRDesignElement)children.get(i);
            listener.getNewSizes().put(element, new Rectangle(0, i * h, cW, h));
        }
        for (JRDesignElement element : listener.getNewSizes().keySet()) {
            Rectangle rectangle = listener.getNewSizes().get(element);
            Widget w = sc.findWidget(element);
            if (w == null) continue;
            Rectangle r = w.getPreferredBounds();
            r.width = rectangle.width;
            r.height = rectangle.height;
            animator.animatePreferredBounds(w, r);
            Point p = new Point(w.getLocation());
            p.x -= element.getX() + rectangle.x;
            p.y += -element.getY() + rectangle.y;
            animator.animatePreferredLocation(w, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellAnimatorListener
    implements AnimatorListener {
        private HashMap<JRDesignElement, Rectangle> newSizes = new HashMap();
        int animations = 0;

        private CellAnimatorListener() {
        }

        public void addAnimation() {
            ++this.animations;
        }

        public void animatorStarted(AnimatorEvent arg0) {
        }

        public void animatorReset(AnimatorEvent arg0) {
        }

        public void animatorFinished(AnimatorEvent arg0) {
            --this.animations;
            if (this.animations == 0) {
                block0: for (JRDesignElement element : this.getNewSizes().keySet()) {
                    Rectangle rectangle = this.getNewSizes().get(element);
                    element.setX(rectangle.x);
                    element.setY(rectangle.y);
                    element.setWidth(rectangle.width);
                    element.setHeight(rectangle.height);
                    if (!(element instanceof JRDesignTextElement)) continue;
                    JRStyledTextParser styledTextParser = JRStyledTextParser.getInstance();
                    JRDesignTextElement dte = (JRDesignTextElement)element;
                    dte.setFontSize(null);
                    for (int i = dte.getFontSize() - 1; i > 1; --i) {
                        String text = "test";
                        Map attributes = JRFontUtil.getAttributes(new HashMap(), (JRFont)dte, (Locale)Locale.getDefault());
                        JRStyledText styledText = styledTextParser.getStyledText(attributes, text, "styled".equals(dte.getMarkup()), Locale.getDefault());
                        IRLocalJasperReportsContext context = IRLocalJasperReportsContext.getInstance();
                        JRTextMeasurerUtil measurerUtil = JRTextMeasurerUtil.getInstance((JasperReportsContext)context);
                        JRTextMeasurer measurer = measurerUtil.createTextMeasurer((JRCommonText)dte);
                        JRMeasuredText measuredText = measurer.measure(styledText, 0, dte.getHeight(), true);
                        if (!(measuredText.getTextHeight() > (float)dte.getHeight()) || i <= 1) continue block0;
                        dte.setFontSize(i);
                    }
                }
            }
        }

        public void animatorPreTick(AnimatorEvent arg0) {
        }

        public void animatorPostTick(AnimatorEvent arg0) {
        }

        public HashMap<JRDesignElement, Rectangle> getNewSizes() {
            return this.newSizes;
        }
    }
}

