/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.crosstab.wizard.CrosstabWizardPanel1;
import com.jaspersoft.ireport.designer.crosstab.wizard.CrosstabWizardPanel2;
import com.jaspersoft.ireport.designer.crosstab.wizard.CrosstabWizardPanel3;
import com.jaspersoft.ireport.designer.crosstab.wizard.CrosstabWizardPanel4;
import com.jaspersoft.ireport.designer.crosstab.wizard.CrosstabWizardPanel5;
import com.jaspersoft.ireport.designer.palette.actions.CreateReportElementAction;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.utils.ColorSchemaGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import org.netbeans.api.visual.widget.Scene;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class CreateCrosstabAction
extends CreateReportElementAction {
    private WizardDescriptor.Panel[] panels;

    private Color getCellBackgroundColor(Color baseColor, String variant, JRDesignCrosstab crosstab, JRCrosstabOrigin origin) {
        int groupIndex;
        int c_index = -1;
        int r_index = -1;
        Color[] colorMapping = new Color[]{ColorSchemaGenerator.createColor(baseColor, 3, variant), ColorSchemaGenerator.createColor(baseColor, 2, variant), ColorSchemaGenerator.createColor(baseColor, 1, variant)};
        if (origin.getColumnGroupName() != null) {
            c_index = (Integer)crosstab.getColumnGroupIndicesMap().get(origin.getColumnGroupName());
            c_index = crosstab.getColumnGroupsList().size() - 1 - c_index;
        }
        if (origin.getRowGroupName() != null) {
            r_index = (Integer)crosstab.getRowGroupIndicesMap().get(origin.getRowGroupName());
            r_index = crosstab.getRowGroupsList().size() - 1 - r_index;
        }
        if ((groupIndex = Math.max(c_index, r_index)) < 0) {
            return null;
        }
        groupIndex = Math.min(groupIndex, 1);
        switch (origin.getType()) {
            case 7: {
                return colorMapping[groupIndex + 1];
            }
            case 3: 
            case 5: {
                return colorMapping[0];
            }
            case 4: 
            case 6: {
                return colorMapping[groupIndex + 1];
            }
        }
        return null;
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new CrosstabWizardPanel1(), new CrosstabWizardPanel2(), new CrosstabWizardPanel3(), new CrosstabWizardPanel4(), new CrosstabWizardPanel5()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public JRDesignElement createReportElement(JasperDesign jd) {
        boolean cancelled;
        this.panels = null;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle("New crosstab");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            try {
                int cWidth = 0;
                int cHeight = 0;
                JRDesignCrosstab crosstab = new JRDesignCrosstab();
                JRDesignDataset dataset = (JRDesignDataset)wizardDescriptor.getProperty("dataset");
                if (!dataset.isMainDataset()) {
                    JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
                    datasetRun.setDatasetName(dataset.getName());
                    datasetRun.setConnectionExpression((JRExpression)Misc.createExpression("java.sql.Connection", "$P{REPORT_CONNECTION}"));
                    ((JRDesignCrosstabDataset)crosstab.getDataset()).setDatasetRun((JRDatasetRun)datasetRun);
                }
                JRDesignCrosstabRowGroup row1 = (JRDesignCrosstabRowGroup)wizardDescriptor.getProperty("row1");
                row1.setWidth(70);
                cWidth += 70;
                JRDesignCrosstabRowGroup row2 = (JRDesignCrosstabRowGroup)wizardDescriptor.getProperty("row2");
                crosstab.addRowGroup(row1);
                if (row2 != null) {
                    row2.setName(this.getUniqueName(row2.getName(), new JRCrosstabGroup[]{row1}));
                    row2.setWidth(70);
                    cWidth += 70;
                    crosstab.addRowGroup(row2);
                }
                JRDesignCrosstabColumnGroup col1 = (JRDesignCrosstabColumnGroup)wizardDescriptor.getProperty("column1");
                col1.setHeight(30);
                cHeight += 30;
                col1.setName(this.getUniqueName(col1.getName(), new JRCrosstabGroup[]{row1, row2}));
                JRDesignCrosstabColumnGroup col2 = (JRDesignCrosstabColumnGroup)wizardDescriptor.getProperty("column2");
                crosstab.addColumnGroup(col1);
                if (col2 != null) {
                    col2.setName(this.getUniqueName(col2.getName(), new JRCrosstabGroup[]{col1, row1, row2}));
                    col2.setHeight(30);
                    cHeight += 30;
                    crosstab.addColumnGroup(col2);
                }
                JRDesignCrosstabMeasure measure = (JRDesignCrosstabMeasure)wizardDescriptor.getProperty("measure");
                crosstab.addMeasure(measure);
                JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                cell.setWidth(Integer.valueOf(50));
                cWidth += 50;
                cell.setHeight(Integer.valueOf(25));
                cHeight += 25;
                cell.setContents(new JRDesignCellContents());
                ((JRDesignCellContents)cell.getContents()).addElement((JRDesignElement)this.createField(Misc.createExpression(measure.getValueClassName(), "$V{" + measure.getName() + "}"), 50, 25));
                crosstab.addCell(cell);
                List cols = crosstab.getColumnGroupsList();
                List rows = crosstab.getRowGroupsList();
                for (int i = 0; i < rows.size(); ++i) {
                    JRDesignCrosstabRowGroup row = (JRDesignCrosstabRowGroup)rows.get(i);
                    JRDesignCrosstabCell rowCell = new JRDesignCrosstabCell();
                    rowCell.setRowTotalGroup(row.getName());
                    rowCell.setContents(new JRDesignCellContents());
                    rowCell.setHeight(Integer.valueOf(25));
                    cHeight += 25;
                    ((JRDesignCellContents)rowCell.getContents()).addElement((JRDesignElement)this.createField(Misc.createExpression(measure.getValueClassName(), "$V{" + measure.getName() + "}"), 50, 25));
                    crosstab.addCell(rowCell);
                    for (int j = 0; j < cols.size(); ++j) {
                        JRDesignCrosstabColumnGroup col = (JRDesignCrosstabColumnGroup)cols.get(j);
                        if (i == 0) {
                            JRDesignCrosstabCell colCell = new JRDesignCrosstabCell();
                            colCell.setColumnTotalGroup(col.getName());
                            colCell.setContents(new JRDesignCellContents());
                            colCell.setWidth(Integer.valueOf(50));
                            cWidth += 50;
                            ((JRDesignCellContents)colCell.getContents()).addElement((JRDesignElement)this.createField(Misc.createExpression(measure.getValueClassName(), "$V{" + measure.getName() + "}"), 50, 25));
                            crosstab.addCell(colCell);
                        }
                        JRDesignCrosstabCell subtotalCell = new JRDesignCrosstabCell();
                        subtotalCell.setRowTotalGroup(row.getName());
                        subtotalCell.setColumnTotalGroup(col.getName());
                        subtotalCell.setContents(new JRDesignCellContents());
                        ((JRDesignCellContents)subtotalCell.getContents()).addElement((JRDesignElement)this.createField(Misc.createExpression(measure.getValueClassName(), "$V{" + measure.getName() + "}"), 50, 25));
                        crosstab.addCell(subtotalCell);
                    }
                }
                boolean addRowTotal = true;
                if (wizardDescriptor.getProperty("rowGroupTotals") != null) {
                    addRowTotal = (Boolean)wizardDescriptor.getProperty("rowGroupTotals");
                }
                if (addRowTotal) {
                    row1.setTotalPosition(CrosstabTotalPositionEnum.END);
                    if (row2 != null) {
                        row2.setTotalPosition(CrosstabTotalPositionEnum.END);
                    }
                }
                boolean addColumnTotal = true;
                if (wizardDescriptor.getProperty("columnGroupTotals") != null) {
                    addColumnTotal = (Boolean)wizardDescriptor.getProperty("columnGroupTotals");
                }
                if (addColumnTotal) {
                    col1.setTotalPosition(CrosstabTotalPositionEnum.END);
                    if (col2 != null) {
                        col2.setTotalPosition(CrosstabTotalPositionEnum.END);
                    }
                }
                boolean showGrid = true;
                if (wizardDescriptor.getProperty("showGrid") != null) {
                    showGrid = (Boolean)wizardDescriptor.getProperty("showGrid");
                }
                String schemaColor = (String)wizardDescriptor.getProperty("schemaColor");
                String schemaVariant = (String)wizardDescriptor.getProperty("schemaVariant");
                boolean whiteGrid = false;
                if (wizardDescriptor.getProperty("whiteGrid") != null) {
                    whiteGrid = (Boolean)wizardDescriptor.getProperty("whiteGrid");
                }
                ((JRDesignCellContents)row1.getHeader()).addElement((JRDesignElement)this.createField(Misc.createExpression(row1.getBucket().getExpression().getValueClassName(), "$V{" + row1.getName() + "}"), 70, 25));
                if (addRowTotal) {
                    ((JRDesignCellContents)row1.getTotalHeader()).addElement((JRDesignElement)this.createLabel("Total " + row1.getName(), row2 != null ? 140 : 70, 25));
                }
                if (row2 != null) {
                    ((JRDesignCellContents)row2.getHeader()).addElement((JRDesignElement)this.createField(Misc.createExpression(row2.getBucket().getExpression().getValueClassName(), "$V{" + row2.getName() + "}"), 70, 25));
                    if (addRowTotal) {
                        ((JRDesignCellContents)row2.getTotalHeader()).addElement((JRDesignElement)this.createLabel("Total " + row2.getName(), 70, 25));
                    }
                }
                ((JRDesignCellContents)col1.getHeader()).addElement((JRDesignElement)this.createField(Misc.createExpression(col1.getBucket().getExpression().getValueClassName(), "$V{" + col1.getName() + "}"), 50, 30));
                if (addColumnTotal) {
                    ((JRDesignCellContents)col1.getTotalHeader()).addElement((JRDesignElement)this.createLabel("Total " + col1.getName(), 50, col2 != null ? 60 : 30));
                }
                if (col2 != null) {
                    ((JRDesignCellContents)col2.getHeader()).addElement((JRDesignElement)this.createField(Misc.createExpression(col2.getBucket().getExpression().getValueClassName(), "$V{" + col2.getName() + "}"), 50, 30));
                    if (addColumnTotal) {
                        ((JRDesignCellContents)col2.getTotalHeader()).addElement((JRDesignElement)this.createLabel("Total " + col2.getName(), 50, 30));
                    }
                }
                List<JRDesignCellContents> contents = ModelUtils.getAllCells(crosstab);
                Color baseColor = schemaColor != null ? ColorSchemaGenerator.getColor(schemaColor) : null;
                schemaVariant = schemaVariant == null ? "light" : schemaVariant;
                for (JRDesignCellContents content : contents) {
                    Color c;
                    if (content == null) continue;
                    if (showGrid) {
                        content.getLineBox().getPen().setLineColor(whiteGrid ? Color.WHITE : Color.BLACK);
                        content.getLineBox().getPen().setLineWidth(0.5f);
                        content.getLineBox().getPen().setLineStyle(LineStyleEnum.SOLID);
                    }
                    if (baseColor == null || (c = this.getCellBackgroundColor(baseColor, schemaVariant, crosstab, content.getOrigin())) == null) continue;
                    content.setBackcolor(c);
                    content.setMode(ModeEnum.OPAQUE);
                    int luminance = (30 * c.getRed() + 59 * c.getGreen() + 11 * c.getBlue()) / 255;
                    if (luminance >= 50) continue;
                    JRElement[] elements = content.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        if (!(elements[i] instanceof JRDesignTextElement)) continue;
                        ((JRDesignTextElement)elements[i]).setForecolor(Color.WHITE);
                    }
                }
                crosstab.setWidth(cWidth);
                crosstab.setHeight(cHeight);
                return crosstab;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private JRDesignStaticText createLabel(String text, int w, int h) {
        JRDesignStaticText element = new JRDesignStaticText();
        element.setX(0);
        element.setY(0);
        element.setWidth(w);
        element.setHeight(h);
        element.setText(text);
        element.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
        element.setVerticalAlignment(VerticalAlignEnum.MIDDLE);
        return element;
    }

    private JRDesignTextField createField(JRDesignExpression exp, int w, int h) {
        JRDesignStyle dataTextfieldStyle = null;
        String styleName = "Crosstab Data Text";
        if (!this.getJasperDesign().getStylesMap().containsKey(styleName)) {
            try {
                dataTextfieldStyle = new JRDesignStyle();
                dataTextfieldStyle.setName(styleName);
                dataTextfieldStyle.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
                this.getJasperDesign().addStyle((JRStyle)dataTextfieldStyle);
            }
            catch (JRException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            dataTextfieldStyle = (JRDesignStyle)this.getJasperDesign().getStylesMap().get(styleName);
        }
        JRDesignTextField element = new JRDesignTextField();
        element.setX(0);
        element.setY(0);
        element.setWidth(w);
        element.setHeight(h);
        if (dataTextfieldStyle != null) {
            element.setStyle((JRStyle)dataTextfieldStyle);
        }
        try {
            CreateTextFieldAction.setMatchingClassExpression(exp, exp.getValueClassName(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        element.setExpression((JRExpression)exp);
        return element;
    }

    private String getUniqueName(String base, JRCrosstabGroup ... grps) {
        int j = 1;
        String new_name = base;
        boolean valid = false;
        while (!valid) {
            valid = true;
            for (int i = 0; i < grps.length; ++i) {
                if (grps[i] == null || !grps[i].getName().equals(new_name)) continue;
                valid = false;
                break;
            }
            if (valid) break;
            new_name = base + j;
            ++j;
        }
        return new_name;
    }

    public void adjustElement(JRDesignElement[] elements, int index, Scene theScene, JasperDesign jasperDesign, Object parent, Point dropLocation) {
        elements[index].setX(0);
        elements[index].setY(0);
        elements[index].setWidth(jasperDesign.getPageWidth() - jasperDesign.getLeftMargin() - jasperDesign.getRightMargin());
        if (parent instanceof JRBand) {
            elements[index].setHeight(((JRBand)parent).getHeight());
        }
    }
}

