/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx.nodes;

import com.jaspersoft.ireport.designer.jrctx.nodes.AxisSettingsNode;
import com.jaspersoft.ireport.designer.jrctx.nodes.ChartSettingsNode;
import com.jaspersoft.ireport.designer.jrctx.nodes.LegendSettingsNode;
import com.jaspersoft.ireport.designer.jrctx.nodes.PlotSettingsNode;
import com.jaspersoft.ireport.designer.jrctx.nodes.TitleSettingsNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import java.util.ArrayList;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

class ChartThemeChildren
extends Children.Keys {
    ChartThemeSettings template = null;
    private Lookup doLkp = null;

    public ChartThemeChildren(ChartThemeSettings template, Lookup doLkp) {
        this.template = template;
        this.doLkp = doLkp;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateChildren();
    }

    protected Node[] createNodes(Object key) {
        IRAbstractNode node = null;
        if (key.equals("Chart")) {
            node = new ChartSettingsNode(this.template.getChartSettings(), this.doLkp);
        } else if (key.equals("Title")) {
            node = new TitleSettingsNode(this.template.getTitleSettings(), this.doLkp);
        } else if (key.equals("Subtitle")) {
            node = new TitleSettingsNode(this.template.getSubtitleSettings(), this.doLkp);
        } else if (key.equals("Legend")) {
            node = new LegendSettingsNode(this.template.getLegendSettings(), this.doLkp);
        } else if (key.equals("Plot")) {
            node = new PlotSettingsNode(this.template.getPlotSettings(), this.doLkp);
        } else if (key.equals("Domain Axis")) {
            node = new AxisSettingsNode(this.template.getDomainAxisSettings(), this.doLkp);
        } else if (key.equals("Range Axis")) {
            node = new AxisSettingsNode(this.template.getRangeAxisSettings(), this.doLkp);
        }
        node.setDisplayName("" + key);
        return new Node[]{node};
    }

    public void updateChildren() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Chart");
        l.add("Title");
        l.add("Subtitle");
        l.add("Legend");
        l.add("Plot");
        l.add("Domain Axis");
        l.add("Range Axis");
        this.setKeys(l);
    }
}

