/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compatibility;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.compatibility.VersionJRContext;
import com.jaspersoft.ireport.designer.compatibility.VersionWarningDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRConstants;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRXmlWriterHelper {
    private static final List<String> jrVersions = new ArrayList<String>();
    private static VersionWarningDialog dialog;

    public static List<String> getJRVersions() {
        return jrVersions;
    }

    public static String writeReport(JRReport report, String encoding) throws Exception {
        JRXmlWriter writer = new JRXmlWriter((JasperReportsContext)new VersionJRContext(null));
        return writer.write(report, encoding);
    }

    public static String writeReport(JRReport report, String encoding, String version) throws Exception {
        JRXmlWriter writer = new JRXmlWriter((JasperReportsContext)new VersionJRContext(version));
        if (IReportManager.getPreferences().getBoolean("show_compatibility_warning", true)) {
            JRXmlWriterHelper.setDialog(null);
            JRXmlWriterHelper.getDialog().setVersion(version);
            if (SwingUtilities.isEventDispatchThread()) {
                JRXmlWriterHelper.getDialog().setVisible(true);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JRXmlWriterHelper.getDialog().setVisible(true);
                    }
                });
            }
            int res = JRXmlWriterHelper.getDialog().getDialogResult();
            if (!JRXmlWriterHelper.getDialog().askAgain()) {
                IReportManager.getPreferences().putBoolean("show_compatibility_warning", false);
            }
            if (res == VersionWarningDialog.DIALOG_RESULT_USE_LAST_VERSION) {
                version = null;
            }
        }
        writer = new JRXmlWriter((JasperReportsContext)new VersionJRContext(version));
        return writer.write(report, encoding);
    }

    public static VersionWarningDialog getDialog() {
        if (dialog == null) {
            Runnable run = new Runnable(){

                public void run() {
                    JRXmlWriterHelper.setDialog(new VersionWarningDialog(Misc.getMainFrame(), true));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return dialog;
    }

    public static void setDialog(VersionWarningDialog dlg) {
        dialog = dlg;
    }

    static {
        for (Field f : JRConstants.class.getFields()) {
            if (!f.getName().startsWith("VERSION_")) continue;
            try {
                jrVersions.add((String)f.get(null));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        dialog = null;
    }
}

