/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.NullBand;
import com.jaspersoft.ireport.designer.outline.nodes.NullBandNode;
import com.jaspersoft.ireport.designer.undo.AddBandUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class AddBandAction
extends NodeAction {
    private static AddBandAction instance = null;

    public static synchronized AddBandAction getInstance() {
        if (instance == null) {
            instance = new AddBandAction();
        }
        return instance;
    }

    private AddBandAction() {
    }

    public String getName() {
        return I18n.getString("BandAction.Name.CTL_AddBandAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            JRDesignGroup g;
            if (!(activatedNodes[i] instanceof NullBandNode)) continue;
            NullBandNode nbn = (NullBandNode)activatedNodes[i];
            JasperDesign jd = (JasperDesign)nbn.getLookup().lookup(JasperDesign.class);
            NullBand band = (NullBand)nbn.getLookup().lookup(NullBand.class);
            if (jd == null || band == null) continue;
            JRDesignBand b = new JRDesignBand();
            b.setHeight(50);
            if (band.getOrigin().getBandTypeValue() == BandTypeEnum.BACKGROUND) {
                jd.setBackground((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.TITLE) {
                jd.setTitle((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.PAGE_HEADER) {
                jd.setPageHeader((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.COLUMN_HEADER) {
                jd.setColumnHeader((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.DETAIL) {
                ((JRDesignSection)jd.getDetailSection()).addBand((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.COLUMN_FOOTER) {
                jd.setColumnFooter((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.PAGE_FOOTER) {
                jd.setPageFooter((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.LAST_PAGE_FOOTER) {
                jd.setLastPageFooter((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.SUMMARY) {
                jd.setSummary((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.NO_DATA) {
                jd.setNoData((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.GROUP_HEADER) {
                g = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                ((JRDesignSection)g.getGroupHeaderSection()).addBand((JRBand)b);
            } else if (band.getOrigin().getBandTypeValue() == BandTypeEnum.GROUP_FOOTER) {
                g = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                ((JRDesignSection)g.getGroupFooterSection()).addBand((JRBand)b);
            }
            AddBandUndoableEdit edit = new AddBandUndoableEdit(b, jd);
            IReportManager.getInstance().addUndoableEdit(edit);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof NullBandNode) continue;
            return false;
        }
        return true;
    }
}

