/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import org.apache.log4j.Logger;

public class PostgreSqlDialect
extends JdbcDialectImpl {
    private static final Logger LOGGER = Logger.getLogger(PostgreSqlDialect.class);
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(PostgreSqlDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && !PostgreSqlDialect.isGreenplum(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public PostgreSqlDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public boolean requiresAliasForFromQuery() {
        return true;
    }

    protected String generateOrderByNullsLast(String expr, boolean ascending) {
        if (this.productVersion.compareTo("8.3") >= 0) {
            return this.generateOrderByNullsLastAnsi(expr, ascending);
        }
        return super.generateOrderByNullsLast(expr, ascending);
    }

    public static boolean isGreenplum(DatabaseMetaData databaseMetaData) {
        boolean bl;
        Statement statement = null;
        try {
            statement = databaseMetaData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("select version()");
            if (resultSet.next()) {
                String version = resultSet.getString(1);
                LOGGER.info((Object)("Version=" + version));
                if (version != null && version.toLowerCase().indexOf("greenplum") != -1) {
                    LOGGER.info((Object)"Using GREENPLUM dialect");
                    boolean bl2 = true;
                    return bl2;
                }
            }
            LOGGER.info((Object)"Using POSTGRES dialect");
            bl = false;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while running query to detect Greenplum database");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
        return bl;
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.POSTGRESQL;
    }
}

