/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberCalculation;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.spi.Dialect;
import mondrian.util.Format;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapEvaluator
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(RolapEvaluator.class);
    private static final Object nullResult = new Object();
    private final RolapMember[] currentMembers;
    private final RolapEvaluator parent;
    protected CellReader cellReader;
    private final int depth;
    private Member expandingMember;
    private boolean firstExpanding;
    private boolean nonEmpty;
    protected final RolapEvaluatorRoot root;
    private int iterationLength = 1;
    private boolean evalAxes;
    private final RolapCalculation[] calcMembers;
    private int calcMemberCount;
    protected List<List<Member[]>> aggregationLists;
    private final List<Member> slicerMembers;
    private Boolean nativeEnabled;
    private Member[] nonAllMembers;

    public Set<Exp> getActiveNativeExpansions() {
        return this.root.activeNativeExpansions;
    }

    protected RolapEvaluator(RolapEvaluatorRoot root, RolapEvaluator parent) {
        this.root = root;
        assert (parent != null);
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.nonEmpty = parent.nonEmpty;
        this.nativeEnabled = parent.nativeEnabled;
        this.evalAxes = parent.evalAxes;
        this.cellReader = parent.cellReader;
        this.currentMembers = (RolapMember[])parent.currentMembers.clone();
        this.calcMembers = (RolapCalculation[])parent.calcMembers.clone();
        this.calcMemberCount = parent.calcMemberCount;
        this.slicerMembers = new ArrayList<Member>(parent.slicerMembers);
        this.aggregationLists = parent.aggregationLists != null ? new ArrayList<List<Member[]>>(parent.aggregationLists) : null;
        this.expandingMember = parent.expandingMember;
    }

    public RolapEvaluator(RolapEvaluatorRoot root) {
        this.root = root;
        this.parent = null;
        this.depth = 0;
        this.nonEmpty = false;
        this.nativeEnabled = MondrianProperties.instance().EnableNativeNonEmpty.get() || MondrianProperties.instance().EnableNativeCrossJoin.get();
        this.evalAxes = false;
        this.cellReader = null;
        this.currentMembers = (RolapMember[])root.defaultMembers.clone();
        this.calcMembers = new RolapCalculation[this.currentMembers.length];
        this.calcMemberCount = 0;
        this.slicerMembers = new ArrayList<Member>();
        this.aggregationLists = null;
        for (RolapMember member : this.currentMembers) {
            if (!member.isEvaluated()) continue;
            this.addCalcMember(new RolapMemberCalculation(member));
        }
        root.init(this);
    }

    public static Evaluator create(Query query) {
        RolapEvaluatorRoot root = new RolapEvaluatorRoot(query);
        return new RolapEvaluator(root);
    }

    @Override
    public RolapCube getMeasureCube() {
        RolapMember measure = this.currentMembers[0];
        if (measure instanceof RolapStoredMeasure) {
            return ((RolapStoredMeasure)((Object)measure)).getCube();
        }
        return null;
    }

    @Override
    public boolean needToReturnNullForUnrelatedDimension(Member[] members) {
        RolapCube virtualCube = this.getCube();
        RolapCube baseCube = this.getMeasureCube();
        if (virtualCube.isVirtual() && baseCube != null) {
            Set<Dimension> nonJoiningDimensions;
            if (virtualCube.shouldIgnoreUnrelatedDimensions(baseCube.getName())) {
                return false;
            }
            if (MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get() && !(nonJoiningDimensions = baseCube.nonJoiningDimensions(members)).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean nativeEnabled() {
        return this.nativeEnabled;
    }

    @Override
    public boolean currentIsEmpty() {
        Object o = this.evaluateCurrent();
        if (o == Util.nullValue || o == null) {
            return true;
        }
        RolapCube measureCube = this.getMeasureCube();
        if (measureCube == null) {
            return false;
        }
        RolapEvaluator eval2 = this.push(measureCube.getFactCountMeasure());
        o = eval2.evaluateCurrent();
        return o == null || o instanceof Number && ((Number)o).intValue() == 0;
    }

    @Override
    public void setNativeEnabled(Boolean nativeEnabled) {
        this.nativeEnabled = nativeEnabled;
    }

    protected final Logger getLogger() {
        return LOGGER;
    }

    @Override
    public final Member[] getMembers() {
        return this.currentMembers;
    }

    @Override
    public final Member[] getNonAllMembers() {
        if (this.nonAllMembers == null) {
            this.nonAllMembers = new RolapMember[this.root.nonAllPositionCount];
            for (int i = 0; i < this.root.nonAllPositionCount; ++i) {
                int nonAllPosition = this.root.nonAllPositions[i];
                this.nonAllMembers[i] = this.currentMembers[nonAllPosition];
            }
        }
        return this.nonAllMembers;
    }

    public final List<List<Member[]>> getAggregationLists() {
        return this.aggregationLists;
    }

    final void setCellReader(CellReader cellReader) {
        this.cellReader = cellReader;
    }

    @Override
    public final RolapCube getCube() {
        return this.root.cube;
    }

    @Override
    public final Query getQuery() {
        return this.root.query;
    }

    @Override
    public final int getDepth() {
        return this.depth;
    }

    @Override
    public final RolapEvaluator getParent() {
        return this.parent;
    }

    @Override
    public final SchemaReader getSchemaReader() {
        return this.root.schemaReader;
    }

    @Override
    public Date getQueryStartTime() {
        return this.root.getQueryStartTime();
    }

    public Dialect getDialect() {
        return this.root.currentDialect;
    }

    @Override
    public final RolapEvaluator push(Member[] members) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push(Member member) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public Evaluator push(boolean nonEmpty) {
        RolapEvaluator evaluator = this._push();
        evaluator.setNonEmpty(nonEmpty);
        return evaluator;
    }

    @Override
    public Evaluator push(boolean nonEmpty, boolean nativeEnabled) {
        RolapEvaluator evaluator = this._push();
        evaluator.setNonEmpty(nonEmpty);
        evaluator.setNativeEnabled(nativeEnabled);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push() {
        return this._push();
    }

    public RolapEvaluator push(RolapCalculation calc) {
        RolapEvaluator evaluator = this.push();
        evaluator.addCalcMember(calc);
        return evaluator;
    }

    protected RolapEvaluator _push() {
        this.getQuery().checkCancelOrTimeout();
        return new RolapEvaluator(this.root, this);
    }

    @Override
    public final RolapEvaluator pop() {
        return this.parent;
    }

    @Override
    public final Evaluator pushAggregation(List<Member[]> list) {
        RolapEvaluator newEvaluator = this._push();
        newEvaluator.addToAggregationList(list);
        this.clearHierarchyFromRegularContext(list, newEvaluator);
        return newEvaluator;
    }

    private void addToAggregationList(List<Member[]> list) {
        if (this.aggregationLists == null) {
            this.aggregationLists = new ArrayList<List<Member[]>>();
        }
        this.aggregationLists.add(list);
    }

    private void clearHierarchyFromRegularContext(List<Member[]> list, RolapEvaluator newEvaluator) {
        Member[] tuple;
        for (Member member : tuple = list.get(0)) {
            newEvaluator.setContext(member.getHierarchy().getAllMember());
        }
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof RolapEvaluator)) {
            return false;
        }
        RolapEvaluator that = (RolapEvaluator)obj;
        return Arrays.equals(this.currentMembers, that.currentMembers);
    }

    public final int hashCode() {
        return Util.hashArray(0, this.currentMembers);
    }

    public final void setSlicerContext(Member member) {
        this.setContext(member);
        this.slicerMembers.add(member);
    }

    public final List<Member> getSlicerMembers() {
        return this.slicerMembers;
    }

    @Override
    public final Member setContext(Member member) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getHierarchy().getOrdinalInCube();
        RolapMember previous = this.currentMembers[ordinal];
        if (m == previous) {
            return m;
        }
        if (previous.isEvaluated()) {
            this.removeCalcMember(new RolapMemberCalculation(previous));
        }
        this.currentMembers[ordinal] = m;
        if (previous.isAll() && !m.isAll() && this.isNewPosition(ordinal)) {
            this.root.nonAllPositions[this.root.nonAllPositionCount] = ordinal;
            ++this.root.nonAllPositionCount;
        }
        if (m.isEvaluated()) {
            this.addCalcMember(new RolapMemberCalculation(m));
        }
        this.nonAllMembers = null;
        return previous;
    }

    private boolean isNewPosition(int ordinal) {
        for (int nonAllPosition : this.root.nonAllPositions) {
            if (ordinal != nonAllPosition) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setContext(List<Member> memberList) {
        int i = 0;
        for (Member member : memberList) {
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null  , count=" + i));
                }
                assert (false);
                continue;
            }
            this.setContext(member);
        }
    }

    @Override
    public final void setContext(Member[] members) {
        for (Member member : members) {
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null, memberList: " + Arrays.asList(members)));
                }
                assert (false);
                continue;
            }
            this.setContext(member);
        }
    }

    @Override
    public final RolapMember getContext(Hierarchy hierarchy) {
        return this.currentMembers[((RolapHierarchy)hierarchy).getOrdinalInCube()];
    }

    public final RolapMember getContext(RolapHierarchy hierarchy) {
        return this.currentMembers[hierarchy.getOrdinalInCube()];
    }

    @Override
    public final Object evaluateCurrent() {
        RolapCalculation maxSolveMember;
        block0 : switch (this.calcMemberCount) {
            case 0: {
                Object o = this.cellReader.get(this);
                if (o == Util.nullValue) {
                    return null;
                }
                return o;
            }
            case 1: {
                maxSolveMember = this.calcMembers[0];
                break;
            }
            default: {
                switch (this.root.solveOrderMode) {
                    case ABSOLUTE: {
                        maxSolveMember = this.getAbsoluteMaxSolveOrder();
                        break block0;
                    }
                    case SCOPED: {
                        maxSolveMember = this.getScopedMaxSolveOrder();
                        break block0;
                    }
                }
                throw Util.unexpected(this.root.solveOrderMode);
            }
        }
        RolapEvaluator evaluator = maxSolveMember.pushSelf(this);
        Calc calc = maxSolveMember.getCompiledExpression(this.root);
        Object o = calc.evaluate(evaluator);
        if (o == Util.nullValue) {
            return null;
        }
        return o;
    }

    void setExpanding(Member member) {
        assert (member != null);
        this.expandingMember = member;
        this.firstExpanding = true;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            RolapEvaluator.checkRecursion(this.parent);
        }
    }

    Member getExpanding() {
        return this.expandingMember;
    }

    private static void checkRecursion(RolapEvaluator eval) {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.firstExpanding) break;
            eval = eval.parent;
        }
        RolapEvaluator eval2 = eval.parent;
        while (eval2 != null) {
            block7: {
                if (eval2.firstExpanding && eval2.expandingMember == eval.expandingMember) {
                    for (int i = 0; i < eval.currentMembers.length; ++i) {
                        RolapMember member = eval2.currentMembers[i];
                        if (member == null) {
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug((Object)("RolapEvaluator.checkRecursion: member == null  , count=" + i));
                            continue;
                        }
                        RolapMember parentMember = eval.getContext(member.getHierarchy());
                        if (member == parentMember) {
                            continue;
                        }
                        break block7;
                    }
                    throw FunUtil.newEvalException(null, "Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
                }
            }
            eval2 = eval2.parent;
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuilder buf = new StringBuilder("{");
        int frameCount = 0;
        RolapEvaluator eval = this;
        while (eval != null) {
            if (eval.expandingMember != null) {
                if (frameCount++ > 0) {
                    buf.append(", ");
                }
                buf.append("(");
                int memberCount = 0;
                for (RolapMember m : eval.currentMembers) {
                    if (m == m.getHierarchy().getDefaultMember()) continue;
                    if (memberCount++ > 0) {
                        buf.append(", ");
                    }
                    buf.append(m.getUniqueName());
                }
                buf.append(")");
            }
            eval = eval.parent;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public final Object getProperty(String name, Object defaultValue) {
        Object o = defaultValue;
        int maxSolve = Integer.MIN_VALUE;
        int i = -1;
        for (Member member : this.getNonAllMembers()) {
            Object p;
            ++i;
            if (member == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.getProperty: member == null  , count=" + i));
                continue;
            }
            int solve = member.getSolveOrder();
            if (solve <= maxSolve || (p = member.getPropertyValue(name)) == null) continue;
            o = p;
            maxSolve = solve;
        }
        return o;
    }

    @Override
    public final String getFormatString() {
        Exp formatExp = (Exp)this.getProperty(Property.FORMAT_EXP.name, null);
        if (formatExp == null) {
            return "Standard";
        }
        Calc formatCalc = this.root.getCompiled(formatExp, true, null);
        Object o = formatCalc.evaluate(this);
        if (o == null) {
            return "Standard";
        }
        return o.toString();
    }

    private Format getFormat() {
        String formatString = this.getFormatString();
        return this.getFormat(formatString);
    }

    private Format getFormat(String formatString) {
        return Format.get(formatString, this.root.connection.getLocale());
    }

    @Override
    public final Locale getConnectionLocale() {
        return this.root.connection.getLocale();
    }

    @Override
    public final String format(Object o) {
        if (o == Util.nullValue) {
            Format format = this.getFormat();
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat();
        return format.format(o);
    }

    @Override
    public final String format(Object o, String formatString) {
        if (o == Util.nullValue) {
            Format format = this.getFormat(formatString);
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat(formatString);
        return format.format(o);
    }

    private Object getExpResultCacheKey(ExpCacheDescriptor descriptor) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(descriptor.getExp());
        if (this.nonEmpty) {
            key.addAll(Arrays.asList(this.currentMembers));
            return key;
        }
        int[] hierarchyOrdinals = descriptor.getDependentHierarchyOrdinals();
        for (int i = 0; i < hierarchyOrdinals.length; ++i) {
            int hierarchyOrdinal = hierarchyOrdinals[i];
            RolapMember member = this.currentMembers[hierarchyOrdinal];
            if (member == null) {
                this.getLogger().debug((Object)("RolapEvaluator.getExpResultCacheKey: member == null; hierarchyOrdinal=" + i));
                continue;
            }
            key.add(member);
        }
        return key;
    }

    @Override
    public final Object getCachedResult(ExpCacheDescriptor cacheDescriptor) {
        Object key = this.getExpResultCacheKey(cacheDescriptor);
        Object result = this.root.getCacheResult(key);
        if (result == null) {
            boolean aggCacheDirty = this.cellReader.isDirty();
            int aggregateCacheMissCountBefore = this.cellReader.getMissCount();
            result = cacheDescriptor.evaluate(this);
            int aggregateCacheMissCountAfter = this.cellReader.getMissCount();
            boolean isValidResult = !aggCacheDirty && aggregateCacheMissCountBefore == aggregateCacheMissCountAfter;
            this.root.putCacheResult(key, result == null ? nullResult : result, isValidResult);
        } else if (result == nullResult) {
            result = null;
        }
        return result;
    }

    public final void clearExpResultCache(boolean clearValidResult) {
        this.root.clearResultCache(clearValidResult);
    }

    @Override
    public final boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public final void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    @Override
    public final RuntimeException newEvalException(Object context, String s) {
        return FunUtil.newEvalException((FunDef)context, s);
    }

    @Override
    public final Evaluator.NamedSetEvaluator getNamedSetEvaluator(NamedSet namedSet, boolean create) {
        return this.root.evaluateNamedSet(namedSet, create);
    }

    @Override
    public final int getMissCount() {
        return this.cellReader.getMissCount();
    }

    @Override
    public final Object getParameterValue(ParameterSlot slot) {
        return this.root.getParameterValue(slot);
    }

    final void addCalcMember(RolapCalculation member) {
        assert (member != null);
        this.calcMembers[this.calcMemberCount++] = member;
    }

    private RolapCalculation getAbsoluteMaxSolveOrder() {
        RolapCalculation maxSolveMember = this.calcMembers[0];
        for (int i = 1; i < this.calcMemberCount; ++i) {
            RolapCalculation member = this.calcMembers[i];
            if (!this.expandsBefore(member, maxSolveMember)) continue;
            maxSolveMember = member;
        }
        return maxSolveMember;
    }

    private RolapCalculation getScopedMaxSolveOrder() {
        RolapCalculation maxSolveMember = null;
        ScopedMaxSolveOrderFinderState state = ScopedMaxSolveOrderFinderState.START;
        block6: for (int i = 0; i < this.calcMemberCount; ++i) {
            RolapCalculation member = this.calcMembers[i];
            switch (state) {
                case START: {
                    maxSolveMember = member;
                    if (maxSolveMember.containsAggregateFunction()) {
                        state = ScopedMaxSolveOrderFinderState.AGG_SCOPE;
                        continue block6;
                    }
                    if (maxSolveMember.isCalculatedInQuery()) {
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    continue block6;
                }
                case AGG_SCOPE: {
                    if (member.containsAggregateFunction()) {
                        if (!this.expandsBefore(member, maxSolveMember)) continue block6;
                        maxSolveMember = member;
                        continue block6;
                    }
                    if (member.isCalculatedInQuery()) {
                        maxSolveMember = member;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    maxSolveMember = member;
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    continue block6;
                }
                case CUBE_SCOPE: {
                    if (member.containsAggregateFunction()) continue block6;
                    if (member.isCalculatedInQuery()) {
                        maxSolveMember = member;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    if (!this.expandsBefore(member, maxSolveMember)) continue block6;
                    maxSolveMember = member;
                    continue block6;
                }
                case QUERY_SCOPE: {
                    if (member.containsAggregateFunction() || !member.isCalculatedInQuery() || !this.expandsBefore(member, maxSolveMember)) continue block6;
                    maxSolveMember = member;
                }
            }
        }
        return maxSolveMember;
    }

    private boolean expandsBefore(RolapCalculation calc1, RolapCalculation calc2) {
        int solveOrder2;
        int solveOrder1 = calc1.getSolveOrder();
        if (solveOrder1 > (solveOrder2 = calc2.getSolveOrder())) {
            return true;
        }
        return solveOrder1 == solveOrder2 && calc1.getHierarchyOrdinal() < calc2.getHierarchyOrdinal();
    }

    void removeCalcMember(RolapCalculation previous) {
        for (int i = 0; i < this.calcMemberCount; ++i) {
            RolapCalculation calcMember = this.calcMembers[i];
            if (!calcMember.equals(previous)) continue;
            --this.calcMemberCount;
            this.calcMembers[i] = this.calcMembers[this.calcMemberCount];
            this.calcMembers[this.calcMemberCount] = null;
        }
    }

    @Override
    public final int getIterationLength() {
        return this.iterationLength;
    }

    @Override
    public final void setIterationLength(int length) {
        this.iterationLength = length;
    }

    @Override
    public final boolean isEvalAxes() {
        return this.evalAxes;
    }

    @Override
    public final void setEvalAxes(boolean evalAxes) {
        this.evalAxes = evalAxes;
    }

    @Override
    public boolean shouldIgnoreUnrelatedDimensions() {
        return this.getCube().shouldIgnoreUnrelatedDimensions(this.getMeasureCube().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScopedMaxSolveOrderFinderState {
        START,
        AGG_SCOPE,
        CUBE_SCOPE,
        QUERY_SCOPE;

    }
}

