/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.QueryAxis;
import mondrian.olap.Util;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap4j.MondrianOlap4jCellSetMetaData;
import mondrian.olap4j.MondrianOlap4jConnection;
import org.olap4j.Axis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCellSetAxisMetaData
implements CellSetAxisMetaData {
    private final QueryAxis queryAxis;
    private final MondrianOlap4jCellSetMetaData cellSetMetaData;
    private final List<Property> propertyList = new ArrayList<Property>();

    MondrianOlap4jCellSetAxisMetaData(MondrianOlap4jCellSetMetaData cellSetMetaData, QueryAxis queryAxis) {
        if (queryAxis == null) {
            queryAxis = new QueryAxis(false, null, AxisOrdinal.StandardAxisOrdinal.SLICER, QueryAxis.SubtotalVisibility.Undefined);
        }
        this.queryAxis = queryAxis;
        this.cellSetMetaData = cellSetMetaData;
        for (Id id : queryAxis.getDimensionProperties()) {
            String[] names = id.toStringArray();
            Property property = null;
            if (names.length == 1) {
                property = (Property)Util.lookup(Property.StandardMemberProperty.class, names[0]);
            }
            if (property == null) {
                property = (Property)Util.lookup(cellSetMetaData.query, id.getSegments(), true);
            }
            this.propertyList.add(property);
        }
    }

    public Axis getAxisOrdinal() {
        return Axis.Factory.forOrdinal((int)this.queryAxis.getAxisOrdinal().logicalOrdinal());
    }

    public List<Hierarchy> getHierarchies() {
        return this.getHierarchiesNonFilter();
    }

    private List<Hierarchy> getHierarchiesNonFilter() {
        Exp exp = this.queryAxis.getSet();
        if (exp == null) {
            return Collections.emptyList();
        }
        Type type = exp.getType();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        MondrianOlap4jConnection olap4jConnection = this.cellSetMetaData.olap4jStatement.olap4jConnection;
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (Type elementType : tupleType.elementTypes) {
                hierarchyList.add(olap4jConnection.toOlap4j(elementType.getHierarchy()));
            }
            return hierarchyList;
        }
        return Collections.singletonList(olap4jConnection.toOlap4j(type.getHierarchy()));
    }

    public List<Property> getProperties() {
        return this.propertyList;
    }
}

