/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.Type;

public class DimensionType
implements Type {
    private final Dimension dimension;
    private final String digest;
    public static final DimensionType Unknown = new DimensionType(null);

    public DimensionType(Dimension dimension) {
        this.dimension = dimension;
        StringBuilder buf = new StringBuilder("DimensionType<");
        if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public static DimensionType forDimension(Dimension dimension) {
        return new DimensionType(dimension);
    }

    public static DimensionType forType(Type type) {
        return new DimensionType(type.getDimension());
    }

    public boolean usesDimension(Dimension dimension, boolean definitely) {
        return this.dimension == dimension || definitely && this.dimension == null;
    }

    public boolean usesHierarchy(Hierarchy hierarchy, boolean definitely) {
        return hierarchy.getDimension() == this.dimension && !definitely;
    }

    public Hierarchy getHierarchy() {
        return this.dimension == null ? null : (this.dimension.getHierarchies().length > 1 ? null : this.dimension.getHierarchies()[0]);
    }

    public Level getLevel() {
        return null;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimensionType) {
            DimensionType that = (DimensionType)obj;
            return Util.equals(this.getDimension(), that.getDimension());
        }
        return false;
    }

    public String toString() {
        return this.digest;
    }

    public Type computeCommonType(Type type, int[] conversionCount) {
        if (conversionCount != null && type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            if (Util.equals(hierarchyType.getDimension(), this.dimension)) {
                conversionCount[0] = conversionCount[0] + 1;
                return this;
            }
            return null;
        }
        if (!(type instanceof DimensionType)) {
            return null;
        }
        DimensionType that = (DimensionType)type;
        if (this.getDimension() != null && this.getDimension().equals(that.getDimension())) {
            return new DimensionType(this.getDimension());
        }
        return Unknown;
    }

    public boolean isInstance(Object value) {
        return value instanceof Dimension && (this.dimension == null || value.equals(this.dimension));
    }
}

