/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.olap.FunTable;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalFunTable
extends FunTableImpl {
    private static GlobalFunTable instance = new GlobalFunTable();

    public static GlobalFunTable instance() {
        return instance;
    }

    private GlobalFunTable() {
    }

    @Override
    public void defineFunctions(FunTable.Builder builder) {
        BuiltinFunTable builtinFunTable = BuiltinFunTable.instance();
        List<String> reservedWords = builtinFunTable.getReservedWords();
        for (String reservedWord : reservedWords) {
            builder.defineReserved(reservedWord);
        }
        List<Resolver> resolvers = builtinFunTable.getResolvers();
        for (Resolver resolver : resolvers) {
            builder.define(resolver);
        }
        for (Class clazz : this.lookupUdfImplClasses()) {
            this.defineUdf(builder, clazz);
        }
    }

    private List<Class<UserDefinedFunction>> lookupUdfImplClasses() {
        ServiceDiscovery<UserDefinedFunction> serviceDiscovery = ServiceDiscovery.forClass(UserDefinedFunction.class);
        return serviceDiscovery.getImplementor();
    }

    private void defineUdf(FunTable.Builder builder, Class<UserDefinedFunction> udfClass) {
        UserDefinedFunction udf = Util.createUdf(udfClass, null);
        this.validateFunction(udf);
        builder.define(new UdfResolver(udf));
    }

    private void validateFunction(UserDefinedFunction udf) {
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }

    static {
        instance.init();
    }
}

