/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MemberHelper;

class DistinctFunDef
extends FunDefBase {
    public static final DistinctFunDef instance = new DistinctFunDef();

    private DistinctFunDef() {
        super("Distinct", "Eliminates duplicate tuples from a set.", "fxx");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        return new CalcImpl(call, listCalc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc;

        public CalcImpl(ResolvedFunCall call, ListCalc listCalc) {
            super(call, new Calc[]{listCalc});
            this.listCalc = listCalc;
        }

        @Override
        public List evaluateList(Evaluator evaluator) {
            List list = this.listCalc.evaluateList(evaluator);
            return CalcImpl.distinct(list);
        }

        static List<Object> distinct(List list) {
            HashSet<MemberHelper> set = new HashSet<MemberHelper>(list.size());
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : list) {
                MemberHelper lookupObj = new MemberHelper(element);
                if (!set.add(lookupObj)) continue;
                result.add(element);
            }
            return result;
        }

        @Override
        public List<Member> evaluateMemberList(Evaluator evaluator) {
            List<Member> list = ((MemberListCalc)this.listCalc).evaluateMemberList(evaluator);
            HashSet<Member> set = new HashSet<Member>(list.size());
            ArrayList<Member> result = new ArrayList<Member>();
            for (Member element : list) {
                if (!set.add(element)) continue;
                result.add(element);
            }
            return result;
        }

        @Override
        public List<Member[]> evaluateTupleList(Evaluator evaluator) {
            List<Member[]> list = ((TupleListCalc)this.listCalc).evaluateTupleList(evaluator);
            HashSet<List<Member>> set = new HashSet<List<Member>>(list.size());
            ArrayList<Member[]> result = new ArrayList<Member[]>();
            for (Member[] element : list) {
                if (!set.add(Arrays.asList(element))) continue;
                result.add(element);
            }
            return result;
        }
    }
}

