/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.SerDeStatsStruct;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyNonPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyStruct
extends LazyNonPrimitive<LazySimpleStructObjectInspector>
implements SerDeStatsStruct {
    private static Log LOG = LogFactory.getLog((String)LazyStruct.class.getName());
    boolean parsed;
    long serializedSize;
    int[] startPosition;
    LazyObject[] fields;
    boolean[] fieldInited;
    boolean missingFieldWarned = false;
    boolean extraFieldWarned = false;
    ArrayList<Object> cachedList;

    public LazyStruct(LazySimpleStructObjectInspector oi) {
        super(oi);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        super.init(bytes, start, length);
        this.parsed = false;
        this.serializedSize = length;
    }

    private void parse() {
        byte separator = ((LazySimpleStructObjectInspector)this.oi).getSeparator();
        boolean lastColumnTakesRest = ((LazySimpleStructObjectInspector)this.oi).getLastColumnTakesRest();
        boolean isEscaped = ((LazySimpleStructObjectInspector)this.oi).isEscaped();
        byte escapeChar = ((LazySimpleStructObjectInspector)this.oi).getEscapeChar();
        if (this.fields == null) {
            List<? extends StructField> fieldRefs = ((StructObjectInspector)this.oi).getAllStructFieldRefs();
            this.fields = new LazyObject[fieldRefs.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = LazyFactory.createLazyObject(fieldRefs.get(i).getFieldObjectInspector());
            }
            this.fieldInited = new boolean[this.fields.length];
            this.startPosition = new int[this.fields.length + 1];
        }
        int structByteEnd = this.start + this.length;
        int fieldId = 0;
        int fieldByteBegin = this.start;
        int fieldByteEnd = this.start;
        byte[] bytes = this.bytes.getData();
        while (fieldByteEnd <= structByteEnd) {
            if (fieldByteEnd == structByteEnd || bytes[fieldByteEnd] == separator) {
                if (lastColumnTakesRest && fieldId == this.fields.length - 1) {
                    fieldByteEnd = structByteEnd;
                }
                this.startPosition[fieldId] = fieldByteBegin;
                if (++fieldId == this.fields.length || fieldByteEnd == structByteEnd) {
                    for (int i = fieldId; i <= this.fields.length; ++i) {
                        this.startPosition[i] = fieldByteEnd + 1;
                    }
                    break;
                }
                fieldByteBegin = fieldByteEnd + 1;
                ++fieldByteEnd;
                continue;
            }
            if (isEscaped && bytes[fieldByteEnd] == escapeChar && fieldByteEnd + 1 < structByteEnd) {
                fieldByteEnd += 2;
                continue;
            }
            ++fieldByteEnd;
        }
        if (!this.extraFieldWarned && fieldByteEnd < structByteEnd) {
            this.extraFieldWarned = true;
            LOG.warn((Object)"Extra bytes detected at the end of the row! Ignoring similar problems.");
        }
        if (!this.missingFieldWarned && fieldId < this.fields.length) {
            this.missingFieldWarned = true;
            LOG.warn((Object)("Missing fields! Expected " + this.fields.length + " fields but " + "only got " + fieldId + "! Ignoring similar problems."));
        }
        Arrays.fill(this.fieldInited, false);
        this.parsed = true;
    }

    public Object getField(int fieldID) {
        if (!this.parsed) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        Text nullSequence = ((LazySimpleStructObjectInspector)this.oi).getNullSequence();
        int fieldByteBegin = this.startPosition[fieldID];
        int fieldLength = this.startPosition[fieldID + 1] - this.startPosition[fieldID] - 1;
        if (fieldLength < 0 || fieldLength == nullSequence.getLength() && LazyUtils.compare(this.bytes.getData(), fieldByteBegin, fieldLength, nullSequence.getBytes(), 0, nullSequence.getLength()) == 0) {
            return null;
        }
        if (!this.fieldInited[fieldID]) {
            this.fieldInited[fieldID] = true;
            this.fields[fieldID].init(this.bytes, fieldByteBegin, fieldLength);
        }
        return this.fields[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.parsed) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    @Override
    public Object getObject() {
        return this;
    }

    protected boolean getParsed() {
        return this.parsed;
    }

    protected void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    protected LazyObject[] getFields() {
        return this.fields;
    }

    protected void setFields(LazyObject[] fields) {
        this.fields = fields;
    }

    protected boolean[] getFieldInited() {
        return this.fieldInited;
    }

    protected void setFieldInited(boolean[] fieldInited) {
        this.fieldInited = fieldInited;
    }

    @Override
    public long getRawDataSerializedSize() {
        return this.serializedSize;
    }
}

