/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;

@Description(name="avg", value="_FUNC_(x) - Returns the mean of a set of numbers")
public class GenericUDAFAverage
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFAverage.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case TIMESTAMP: {
                return new GenericUDAFAverageEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class GenericUDAFAverageEvaluator
    extends GenericUDAFEvaluator {
        PrimitiveObjectInspector inputOI;
        StructObjectInspector soi;
        StructField countField;
        StructField sumField;
        LongObjectInspector countFieldOI;
        DoubleObjectInspector sumFieldOI;
        Object[] partialResult;
        DoubleWritable result;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.countField = this.soi.getStructFieldRef("count");
                this.sumField = this.soi.getStructFieldRef("sum");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.sumFieldOI = (DoubleObjectInspector)this.sumField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("count");
                fname.add("sum");
                this.partialResult = new Object[2];
                this.partialResult[0] = new LongWritable(0L);
                this.partialResult[1] = new DoubleWritable(0.0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            this.result = new DoubleWritable(0.0);
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            AverageAgg result = new AverageAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            AverageAgg myagg = (AverageAgg)agg;
            myagg.count = 0L;
            myagg.sum = 0.0;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                Object p = parameters[0];
                if (p != null) {
                    AverageAgg myagg = (AverageAgg)agg;
                    try {
                        double v = PrimitiveObjectInspectorUtils.getDouble(p, this.inputOI);
                        ++myagg.count;
                        myagg.sum += v;
                    }
                    catch (NumberFormatException e) {
                        if (this.warned) break block4;
                        this.warned = true;
                        LOG.warn((Object)(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e)));
                        LOG.warn((Object)(this.getClass().getSimpleName() + " ignoring similar exceptions."));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            AverageAgg myagg = (AverageAgg)agg;
            ((LongWritable)this.partialResult[0]).set(myagg.count);
            ((DoubleWritable)this.partialResult[1]).set(myagg.sum);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                AverageAgg myagg = (AverageAgg)agg;
                Object partialCount = this.soi.getStructFieldData(partial, this.countField);
                Object partialSum = this.soi.getStructFieldData(partial, this.sumField);
                myagg.count += this.countFieldOI.get(partialCount);
                myagg.sum += this.sumFieldOI.get(partialSum);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            AverageAgg myagg = (AverageAgg)agg;
            if (myagg.count == 0L) {
                return null;
            }
            this.result.set(myagg.sum / (double)myagg.count);
            return this.result;
        }

        static class AverageAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            long count;
            double sum;

            AverageAgg() {
            }
        }
    }
}

