/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@Explain(displayName="Map Reduce Local Work")
public class MapredLocalWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork;
    private LinkedHashMap<String, FetchWork> aliasToFetchWork;
    private boolean inputFileChangeSensitive;
    private BucketMapJoinContext bucketMapjoinContext;
    private String tmpFileURI;
    private String stageID;
    private List<Operator<? extends Serializable>> dummyParentOp;

    public MapredLocalWork() {
    }

    public MapredLocalWork(LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork, LinkedHashMap<String, FetchWork> aliasToFetchWork) {
        this.aliasToWork = aliasToWork;
        this.aliasToFetchWork = aliasToFetchWork;
    }

    public MapredLocalWork(MapredLocalWork clone) {
        this.tmpFileURI = clone.tmpFileURI;
        this.inputFileChangeSensitive = clone.inputFileChangeSensitive;
    }

    public void setDummyParentOp(List<Operator<? extends Serializable>> op) {
        this.dummyParentOp = op;
    }

    public List<Operator<? extends Serializable>> getDummyParentOp() {
        return this.dummyParentOp;
    }

    @Explain(displayName="Alias -> Map Local Operator Tree")
    public LinkedHashMap<String, Operator<? extends Serializable>> getAliasToWork() {
        return this.aliasToWork;
    }

    public String getStageID() {
        return this.stageID;
    }

    public void setStageID(String stageID) {
        this.stageID = stageID;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Alias -> Map Local Tables")
    public LinkedHashMap<String, FetchWork> getAliasToFetchWork() {
        return this.aliasToFetchWork;
    }

    public void setAliasToFetchWork(LinkedHashMap<String, FetchWork> aliasToFetchWork) {
        this.aliasToFetchWork = aliasToFetchWork;
    }

    public boolean getInputFileChangeSensitive() {
        return this.inputFileChangeSensitive;
    }

    public void setInputFileChangeSensitive(boolean inputFileChangeSensitive) {
        this.inputFileChangeSensitive = inputFileChangeSensitive;
    }

    public void deriveExplainAttributes() {
        if (this.bucketMapjoinContext != null) {
            this.bucketMapjoinContext.deriveBucketMapJoinMapping();
        }
        for (FetchWork fetchWork : this.aliasToFetchWork.values()) {
            if (fetchWork.getTblDesc() == null) continue;
            PlanUtils.configureTableJobPropertiesForStorageHandler(fetchWork.getTblDesc());
        }
    }

    @Explain(displayName="Bucket Mapjoin Context", normalExplain=false)
    public BucketMapJoinContext getBucketMapjoinContext() {
        return this.bucketMapjoinContext;
    }

    public void setBucketMapjoinContext(BucketMapJoinContext bucketMapjoinContext) {
        this.bucketMapjoinContext = bucketMapjoinContext;
    }

    public void setTmpFileURI(String tmpFileURI) {
        this.tmpFileURI = tmpFileURI;
    }

    public String getTmpFileURI() {
        return this.tmpFileURI;
    }

    public static class BucketMapJoinContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> aliasBucketFileNameMapping;
        private String mapJoinBigTableAlias;
        private Class<? extends BucketMatcher> bucketMatcherClass;
        private LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> aliasBucketBaseFileNameMapping;
        private LinkedHashMap<String, Integer> bucketFileNameMapping;

        public void setMapJoinBigTableAlias(String bigTableAlias) {
            this.mapJoinBigTableAlias = bigTableAlias;
        }

        public void deriveBucketMapJoinMapping() {
            if (this.aliasBucketFileNameMapping != null) {
                Iterator<Map.Entry<String, LinkedHashMap<String, ArrayList<String>>>> iter = this.aliasBucketFileNameMapping.entrySet().iterator();
                this.aliasBucketBaseFileNameMapping = new LinkedHashMap();
                while (iter.hasNext()) {
                    Map.Entry<String, LinkedHashMap<String, ArrayList<String>>> old = iter.next();
                    LinkedHashMap newBucketBaseFileNameMapping = new LinkedHashMap();
                    for (Map.Entry<String, ArrayList<String>> oldTableBucketFileNames : old.getValue().entrySet()) {
                        String bigTblBucketFileName;
                        ArrayList<String> oldTableBucketNames = oldTableBucketFileNames.getValue();
                        ArrayList<String> newTableBucketFileBaseName = new ArrayList<String>(oldTableBucketNames.size());
                        if (oldTableBucketNames != null) {
                            for (String bucketFName : oldTableBucketNames) {
                                newTableBucketFileBaseName.add(this.getBaseFileName(bucketFName));
                            }
                        }
                        if (newBucketBaseFileNameMapping.containsKey(bigTblBucketFileName = this.getBaseFileName(oldTableBucketFileNames.getKey()))) {
                            String fullPath = oldTableBucketFileNames.getKey();
                            String dir = this.getBaseFileName(fullPath.substring(0, fullPath.lastIndexOf(bigTblBucketFileName)));
                            bigTblBucketFileName = dir + File.separator + bigTblBucketFileName;
                        }
                        newBucketBaseFileNameMapping.put(bigTblBucketFileName, newTableBucketFileBaseName);
                    }
                    String tableAlias = old.getKey();
                    this.aliasBucketBaseFileNameMapping.put(tableAlias, newBucketBaseFileNameMapping);
                }
            }
        }

        private String getBaseFileName(String path) {
            try {
                return new Path(path).getName();
            }
            catch (Exception ex) {
                return path;
            }
        }

        public String getMapJoinBigTableAlias() {
            return this.mapJoinBigTableAlias;
        }

        public Class<? extends BucketMatcher> getBucketMatcherClass() {
            return this.bucketMatcherClass;
        }

        public void setBucketMatcherClass(Class<? extends BucketMatcher> bucketMatcherClass) {
            this.bucketMatcherClass = bucketMatcherClass;
        }

        @Explain(displayName="Alias Bucket File Name Mapping", normalExplain=false)
        public LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> getAliasBucketFileNameMapping() {
            return this.aliasBucketFileNameMapping;
        }

        public void setAliasBucketFileNameMapping(LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> aliasBucketFileNameMapping) {
            this.aliasBucketFileNameMapping = aliasBucketFileNameMapping;
        }

        public String toString() {
            if (this.aliasBucketFileNameMapping != null) {
                return "Mapping:" + this.aliasBucketFileNameMapping.toString();
            }
            return "";
        }

        @Explain(displayName="Alias Bucket Base File Name Mapping", normalExplain=false)
        public LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> getAliasBucketBaseFileNameMapping() {
            return this.aliasBucketBaseFileNameMapping;
        }

        public void setAliasBucketBaseFileNameMapping(LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> aliasBucketBaseFileNameMapping) {
            this.aliasBucketBaseFileNameMapping = aliasBucketBaseFileNameMapping;
        }

        @Explain(displayName="Alias Bucket Output File Name Mapping", normalExplain=false)
        public LinkedHashMap<String, Integer> getBucketFileNameMapping() {
            return this.bucketFileNameMapping;
        }

        public void setBucketFileNameMapping(LinkedHashMap<String, Integer> bucketFileNameMapping) {
            this.bucketFileNameMapping = bucketFileNameMapping;
        }
    }
}

