/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Table")
public class CreateTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String databaseName;
    String tableName;
    boolean isExternal;
    ArrayList<FieldSchema> cols;
    ArrayList<FieldSchema> partCols;
    ArrayList<String> bucketCols;
    ArrayList<Order> sortCols;
    int numBuckets;
    String fieldDelim;
    String fieldEscape;
    String collItemDelim;
    String mapKeyDelim;
    String lineDelim;
    String comment;
    String inputFormat;
    String outputFormat;
    String location;
    String serName;
    String storageHandler;
    Map<String, String> serdeProps;
    Map<String, String> tblProps;
    boolean ifNotExists;

    public CreateTableDesc() {
    }

    public CreateTableDesc(String databaseName, String tableName, boolean isExternal, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists) {
        this(tableName, isExternal, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists);
        this.databaseName = databaseName;
    }

    public CreateTableDesc(String tableName, boolean isExternal, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists) {
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.bucketCols = new ArrayList<String>(bucketCols);
        this.sortCols = new ArrayList<Order>(sortCols);
        this.collItemDelim = collItemDelim;
        this.cols = new ArrayList<FieldSchema>(cols);
        this.comment = comment;
        this.fieldDelim = fieldDelim;
        this.fieldEscape = fieldEscape;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.lineDelim = lineDelim;
        this.location = location;
        this.mapKeyDelim = mapKeyDelim;
        this.numBuckets = numBuckets;
        this.partCols = new ArrayList<FieldSchema>(partCols);
        this.serName = serName;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="columns")
    public List<String> getColsString() {
        return Utilities.getFieldSchemaString(this.getCols());
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.getPartCols());
    }

    @Explain(displayName="if not exists")
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="name")
    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ArrayList<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(ArrayList<FieldSchema> cols) {
        this.cols = cols;
    }

    public ArrayList<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(ArrayList<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    @Explain(displayName="bucket columns")
    public ArrayList<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(ArrayList<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    @Explain(displayName="# buckets")
    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    @Explain(displayName="field delimiter")
    public String getFieldDelim() {
        return this.fieldDelim;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    @Explain(displayName="field escape")
    public String getFieldEscape() {
        return this.fieldEscape;
    }

    public void setFieldEscape(String fieldEscape) {
        this.fieldEscape = fieldEscape;
    }

    @Explain(displayName="collection delimiter")
    public String getCollItemDelim() {
        return this.collItemDelim;
    }

    public void setCollItemDelim(String collItemDelim) {
        this.collItemDelim = collItemDelim;
    }

    @Explain(displayName="map key delimiter")
    public String getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public void setMapKeyDelim(String mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
    }

    @Explain(displayName="line delimiter")
    public String getLineDelim() {
        return this.lineDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler")
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Explain(displayName="isExternal")
    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @Explain(displayName="sort columns")
    public ArrayList<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(ArrayList<Order> sortCols) {
        this.sortCols = sortCols;
    }

    @Explain(displayName="serde name")
    public String getSerName() {
        return this.serName;
    }

    public void setSerName(String serName) {
        this.serName = serName;
    }

    @Explain(displayName="serde properties")
    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setSerdeProps(Map<String, String> serdeProps) {
        this.serdeProps = serdeProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }
}

