/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.optimizer.lineage.OpProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class Generator
implements Transform {
    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LineageCtx lCtx = new LineageCtx(pctx);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "TS%"), OpProcFactory.getTSProc());
        opRules.put(new RuleRegExp("R2", "SCR%"), OpProcFactory.getTransformProc());
        opRules.put(new RuleRegExp("R3", "UDTF%"), OpProcFactory.getTransformProc());
        opRules.put(new RuleRegExp("R4", "SEL%"), OpProcFactory.getSelProc());
        opRules.put(new RuleRegExp("R5", "GBY%"), OpProcFactory.getGroupByProc());
        opRules.put(new RuleRegExp("R6", "UNION%"), OpProcFactory.getUnionProc());
        opRules.put(new RuleRegExp("R7", "JOIN%|MAPJOIN%"), OpProcFactory.getJoinProc());
        opRules.put(new RuleRegExp("R8", "RS%"), OpProcFactory.getReduceSinkProc());
        opRules.put(new RuleRegExp("R9", "LVJ%"), OpProcFactory.getLateralViewJoinProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(OpProcFactory.getDefaultProc(), opRules, lCtx);
        PreOrderWalker ogw = new PreOrderWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().setIndex(lCtx.getIndex());
        }
        return pctx;
    }
}

