/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class WriteEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Type typ;
    private Table t;
    private Partition p;
    private String d;
    private String name;
    private boolean complete;

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getTyp() {
        return this.typ;
    }

    public void setTyp(Type typ) {
        this.typ = typ;
    }

    public Table getT() {
        return this.t;
    }

    public void setT(Table t) {
        this.t = t;
    }

    public Partition getP() {
        return this.p;
    }

    public void setP(Partition p) {
        this.p = p;
    }

    public String getD() {
        return this.d;
    }

    public void setD(String d) {
        this.d = d;
    }

    public WriteEntity() {
    }

    public WriteEntity(Table t) {
        this(t, true);
    }

    public WriteEntity(Table t, boolean complete) {
        this.d = null;
        this.p = null;
        this.t = t;
        this.typ = Type.TABLE;
        this.name = this.computeName();
        this.complete = complete;
    }

    public WriteEntity(Partition p) {
        this(p, true);
    }

    public WriteEntity(Partition p, boolean complete) {
        this.d = null;
        this.p = p;
        this.t = p.getTable();
        this.typ = Type.PARTITION;
        this.name = this.computeName();
        this.complete = complete;
    }

    public WriteEntity(DummyPartition p, boolean complete) {
        this.d = null;
        this.p = p;
        this.t = p.getTable();
        this.typ = Type.DUMMYPARTITION;
        this.name = this.computeName();
        this.complete = complete;
    }

    public WriteEntity(String d, boolean islocal) {
        this(d, islocal, true);
    }

    public WriteEntity(String d, boolean islocal, boolean complete) {
        this.d = d;
        this.p = null;
        this.t = null;
        this.typ = islocal ? Type.LOCAL_DIR : Type.DFS_DIR;
        this.name = this.computeName();
        this.complete = complete;
    }

    public Type getType() {
        return this.typ;
    }

    public URI getLocation() throws Exception {
        if (this.typ == Type.TABLE) {
            return this.t.getDataLocation();
        }
        if (this.typ == Type.PARTITION) {
            return this.p.getDataLocation();
        }
        if (this.typ == Type.DFS_DIR || this.typ == Type.LOCAL_DIR) {
            return new URI(this.d);
        }
        return null;
    }

    public Partition getPartition() {
        return this.p;
    }

    public Table getTable() {
        return this.t;
    }

    public String toString() {
        return this.name;
    }

    private String computeName() {
        switch (this.typ) {
            case TABLE: {
                return this.t.getDbName() + "@" + this.t.getTableName();
            }
            case PARTITION: {
                return this.t.getDbName() + "@" + this.t.getTableName() + "@" + this.p.getName();
            }
            case DUMMYPARTITION: {
                return this.p.getName();
            }
        }
        return this.d;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof WriteEntity) {
            WriteEntity ore = (WriteEntity)o;
            return this.toString().equalsIgnoreCase(ore.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum Type {
        TABLE,
        PARTITION,
        DUMMYPARTITION,
        DFS_DIR,
        LOCAL_DIR;

    }
}

