/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import org.apache.hadoop.hive.ql.exec.persistence.DCLLItem;

public class MRU<T extends DCLLItem> {
    T head = null;

    public T put(T item) {
        this.addToHead(item);
        return item;
    }

    public void remove(T v) {
        if (v == null) {
            return;
        }
        if (v == this.head) {
            this.head = this.head != ((DCLLItem)this.head).getNext() ? ((DCLLItem)this.head).getNext() : null;
        }
        ((DCLLItem)v).remove();
    }

    public T head() {
        return this.head;
    }

    public T tail() {
        return (T)((DCLLItem)this.head).getPrev();
    }

    private void addToHead(T v) {
        if (this.head == null) {
            this.head = v;
        } else {
            ((DCLLItem)this.head).insertBefore((DCLLItem)v);
            this.head = v;
        }
    }

    public void moveToHead(T v) {
        assert (this.head != null);
        if (this.head != v) {
            ((DCLLItem)v).remove();
            ((DCLLItem)this.head).insertBefore((DCLLItem)v);
            this.head = v;
        }
    }

    public void clear() {
        while (((DCLLItem)this.head).getNext() != this.head) {
            ((DCLLItem)this.head).getNext().remove();
        }
        ((DCLLItem)this.head).remove();
        this.head = null;
    }
}

