/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class MapOperator
extends Operator<MapredWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable deserialize_error_count = new LongWritable();
    private transient Deserializer deserializer;
    private transient Object[] rowWithPart;
    private transient Writable[] vcValues;
    private transient List<VirtualColumn> vcs;
    private transient Object[] rowWithPartAndVC;
    private transient StructObjectInspector rowObjectInspector;
    private transient boolean isPartitioned;
    private transient boolean hasVC;
    private Map<MapInputPath, MapOpCtx> opCtxMap;
    private final Set<MapInputPath> listInputPaths = new HashSet<MapInputPath>();
    private Map<Operator<? extends Serializable>, ArrayList<String>> operatorToPaths;
    private final Map<Operator<? extends Serializable>, MapOpCtx> childrenOpToOpCtxMap = new HashMap<Operator<? extends Serializable>, MapOpCtx>();
    private ArrayList<Operator<? extends Serializable>> extraChildrenToClose = null;

    public void initializeAsRoot(Configuration hconf, MapredWork mrwork) throws HiveException {
        this.setConf(mrwork);
        this.setChildren(hconf);
        this.initialize(hconf, null);
    }

    private static MapOpCtx initObjectInspector(MapredWork conf, Configuration hconf, String onefile) throws HiveException, ClassNotFoundException, InstantiationException, IllegalAccessException, SerDeException {
        PartitionDesc td = conf.getPathToPartitionInfo().get(onefile);
        LinkedHashMap<String, String> partSpec = td.getPartSpec();
        Properties tblProps = td.getProperties();
        Class sdclass = td.getDeserializerClass();
        if (sdclass == null) {
            String className = td.getSerdeClassName();
            if (className == "" || className == null) {
                throw new HiveException("SerDe class or the SerDe class name is not set for table: " + td.getProperties().getProperty("name"));
            }
            sdclass = hconf.getClassByName(className);
        }
        String tableName = String.valueOf(tblProps.getProperty("name"));
        String partName = String.valueOf(partSpec);
        Deserializer deserializer = sdclass.newInstance();
        deserializer.initialize(hconf, tblProps);
        StructObjectInspector rawRowObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
        MapOpCtx opCtx = null;
        String pcols = tblProps.getProperty("partition_columns");
        if (pcols != null && pcols.length() > 0) {
            String[] partKeys = pcols.trim().split("/");
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            Object[] partValues = new Object[partKeys.length];
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            for (int i = 0; i < partKeys.length; ++i) {
                String key = partKeys[i];
                partNames.add(key);
                partValues[i] = partSpec == null ? new Text() : new Text(partSpec.get(key));
                partObjectInspectors.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            }
            StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
            Object[] rowWithPart = new Object[2];
            rowWithPart[1] = partValues;
            UnionStructObjectInspector rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(rawRowObjectInspector, partObjectInspector));
            opCtx = new MapOpCtx(true, rowObjectInspector, rawRowObjectInspector, partObjectInspector, rowWithPart, deserializer);
        } else {
            opCtx = new MapOpCtx(false, rawRowObjectInspector, rawRowObjectInspector, null, null, deserializer);
        }
        opCtx.tableName = tableName;
        opCtx.partName = partName;
        return opCtx;
    }

    private void setInspectorInput(MapInputPath inp) {
        TableScanOperator tsOp;
        TableScanDesc tsDesc;
        Operator<? extends Serializable> op = inp.getOp();
        this.deserializer = this.opCtxMap.get(inp).getDeserializer();
        this.isPartitioned = this.opCtxMap.get(inp).isPartitioned();
        this.rowWithPart = this.opCtxMap.get(inp).getRowWithPart();
        this.rowObjectInspector = this.opCtxMap.get(inp).getRowObjectInspector();
        if (this.listInputPaths.contains(inp)) {
            return;
        }
        this.listInputPaths.add(inp);
        StructObjectInspector rawRowObjectInspector = this.opCtxMap.get((Object)inp).rawRowObjectInspector;
        StructObjectInspector partObjectInspector = this.opCtxMap.get((Object)inp).partObjectInspector;
        if (op instanceof TableScanOperator && (tsDesc = (TableScanDesc)(tsOp = (TableScanOperator)op).getConf()) != null) {
            this.vcs = tsDesc.getVirtualCols();
            if (this.vcs != null && this.vcs.size() > 0) {
                this.hasVC = true;
                ArrayList<String> vcNames = new ArrayList<String>(this.vcs.size());
                this.vcValues = new Writable[this.vcs.size()];
                ArrayList<ObjectInspector> vcsObjectInspectors = new ArrayList<ObjectInspector>(this.vcs.size());
                for (int i = 0; i < this.vcs.size(); ++i) {
                    VirtualColumn vc = this.vcs.get(i);
                    vcsObjectInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(vc.getTypeInfo().getPrimitiveCategory()));
                    vcNames.add(vc.getName());
                }
                StandardStructObjectInspector vcStructObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(vcNames, vcsObjectInspectors);
                if (this.isPartitioned) {
                    this.rowWithPartAndVC = new Object[3];
                    this.rowWithPartAndVC[1] = this.rowWithPart[1];
                } else {
                    this.rowWithPartAndVC = new Object[2];
                }
                this.rowObjectInspector = partObjectInspector == null ? ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(this.rowObjectInspector, vcStructObjectInspector)) : ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(rawRowObjectInspector, partObjectInspector, vcStructObjectInspector));
                this.opCtxMap.get((Object)inp).rowObjectInspector = this.rowObjectInspector;
            }
        }
    }

    public void setChildren(Configuration hconf) throws HiveException {
        Path fpath = new Path(new Path(HiveConf.getVar(hconf, HiveConf.ConfVars.HADOOPMAPFILENAME)).toUri().getPath());
        ArrayList<Operator<? extends Serializable>> children = new ArrayList<Operator<? extends Serializable>>();
        this.opCtxMap = new HashMap<MapInputPath, MapOpCtx>();
        this.operatorToPaths = new HashMap<Operator<? extends Serializable>, ArrayList<String>>();
        this.statsMap.put(Counter.DESERIALIZE_ERRORS, this.deserialize_error_count);
        try {
            for (String onefile : ((MapredWork)this.conf).getPathToAliases().keySet()) {
                MapOpCtx opCtx = MapOperator.initObjectInspector((MapredWork)this.conf, hconf, onefile);
                Path onepath = new Path(new Path(onefile).toUri().getPath());
                List aliases = ((MapredWork)this.conf).getPathToAliases().get(onefile);
                for (String onealias : aliases) {
                    Operator<? extends Serializable> op = ((MapredWork)this.conf).getAliasToWork().get(onealias);
                    this.LOG.info((Object)("Adding alias " + onealias + " to work list for file " + onefile));
                    MapInputPath inp = new MapInputPath(onefile, onealias, op);
                    this.opCtxMap.put(inp, opCtx);
                    if (this.operatorToPaths.get(op) == null) {
                        this.operatorToPaths.put(op, new ArrayList());
                    }
                    this.operatorToPaths.get(op).add(onefile);
                    op.setParentOperators(new ArrayList<Operator<? extends Serializable>>());
                    op.getParentOperators().add(this);
                    if (!onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) {
                        children.add(op);
                        this.childrenOpToOpCtxMap.put(op, opCtx);
                        this.LOG.info((Object)("dump " + op.getName() + " " + this.opCtxMap.get(inp).getRowObjectInspector().getTypeName()));
                    }
                    this.setInspectorInput(inp);
                }
            }
            if (children.size() == 0) {
                this.LOG.error((Object)("Configuration does not have any alias for path: " + fpath.toUri().getPath()));
                throw new HiveException("Configuration and input path are inconsistent");
            }
            this.setChildOperators(children);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        this.state = Operator.State.INIT;
        List<Operator<Serializable>> children = this.getChildOperators();
        for (Map.Entry<Operator<? extends Serializable>, MapOpCtx> entry : this.childrenOpToOpCtxMap.entrySet()) {
            Operator<? extends Serializable> child = entry.getKey();
            MapOpCtx mapOpCtx = entry.getValue();
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, mapOpCtx.tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, mapOpCtx.partName);
            child.initialize(hconf, new ObjectInspector[]{mapOpCtx.getRowObjectInspector()});
        }
        for (Map.Entry<Object, MapOpCtx> entry : this.opCtxMap.entrySet()) {
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, entry.getValue().tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, entry.getValue().partName);
            MapInputPath input = (MapInputPath)entry.getKey();
            Operator<? extends Serializable> op = input.op;
            if (children.indexOf(op) != -1) continue;
            if (this.extraChildrenToClose == null) {
                this.extraChildrenToClose = new ArrayList();
            }
            this.extraChildrenToClose.add(op);
            op.initialize(hconf, new ObjectInspector[]{entry.getValue().getRowObjectInspector()});
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.extraChildrenToClose != null) {
            for (Operator<? extends Serializable> op : this.extraChildrenToClose) {
                op.close(abort);
            }
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        Path fpath = new Path(new Path(this.getExecContext().getCurrentInputFile()).toUri().getPath());
        for (String onefile : ((MapredWork)this.conf).getPathToAliases().keySet()) {
            Path onepath = new Path(new Path(onefile).toUri().getPath());
            if (onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) continue;
            String onealias = ((MapredWork)this.conf).getPathToAliases().get(onefile).get(0);
            Operator<? extends Serializable> op = ((MapredWork)this.conf).getAliasToWork().get(onealias);
            this.LOG.info((Object)("Processing alias " + onealias + " for file " + onefile));
            MapInputPath inp = new MapInputPath(onefile, onealias, op);
            this.setInspectorInput(inp);
            break;
        }
    }

    public void process(Writable value) throws HiveException {
        if (this.getExecContext() != null && this.getExecContext().inputFileChanged()) {
            this.LOG.info((Object)("Processing path " + this.getExecContext().getCurrentInputFile()));
            this.cleanUpInputFileChanged();
        }
        Object row = null;
        try {
            if (this.hasVC) {
                this.rowWithPartAndVC[0] = this.deserializer.deserialize(value);
                int vcPos = this.isPartitioned ? 2 : 1;
                this.populateVirtualColumnValues();
                this.rowWithPartAndVC[vcPos] = this.vcValues;
            } else if (!this.isPartitioned) {
                row = this.deserializer.deserialize(value);
            } else {
                this.rowWithPart[0] = this.deserializer.deserialize(value);
            }
        }
        catch (Exception e) {
            String rawRowString;
            try {
                rawRowString = value.toString();
            }
            catch (Exception e2) {
                rawRowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            this.deserialize_error_count.set(this.deserialize_error_count.get() + 1L);
            throw new HiveException("Hive Runtime Error while processing writable " + rawRowString, e);
        }
        try {
            if (this.hasVC) {
                this.forward(this.rowWithPartAndVC, this.rowObjectInspector);
            } else if (!this.isPartitioned) {
                this.forward(row, this.rowObjectInspector);
            } else {
                this.forward(this.rowWithPart, this.rowObjectInspector);
            }
        }
        catch (Exception e) {
            String rowString;
            try {
                rowString = this.hasVC ? SerDeUtils.getJSONString(this.rowWithPartAndVC, this.rowObjectInspector) : (!this.isPartitioned ? SerDeUtils.getJSONString(row, this.rowObjectInspector) : SerDeUtils.getJSONString(this.rowWithPart, this.rowObjectInspector));
            }
            catch (Exception e2) {
                rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            throw new HiveException("Hive Runtime Error while processing row " + rowString, e);
        }
    }

    private void populateVirtualColumnValues() {
        if (this.vcs != null) {
            ExecMapperContext mapExecCxt = this.getExecContext();
            IOContext ioCxt = mapExecCxt.getIoCxt();
            for (int i = 0; i < this.vcs.size(); ++i) {
                LongWritable old;
                LongWritable old2;
                long current;
                VirtualColumn vc = this.vcs.get(i);
                if (vc.equals(VirtualColumn.FILENAME) && mapExecCxt.inputFileChanged()) {
                    this.vcValues[i] = new Text(mapExecCxt.getCurrentInputFile());
                    continue;
                }
                if (vc.equals(VirtualColumn.BLOCKOFFSET)) {
                    current = ioCxt.getCurrentBlockStart();
                    old2 = (LongWritable)this.vcValues[i];
                    if (old2 == null) {
                        old2 = new LongWritable(current);
                        this.vcValues[i] = old2;
                        continue;
                    }
                    if (current == old2.get()) continue;
                    old2.set(current);
                    continue;
                }
                if (vc.equals(VirtualColumn.ROWOFFSET)) {
                    current = ioCxt.getCurrentRow();
                    old2 = (LongWritable)this.vcValues[i];
                    if (old2 == null) {
                        old2 = new LongWritable(current);
                        this.vcValues[i] = old2;
                        continue;
                    }
                    if (current == old2.get()) continue;
                    old2.set(current);
                    continue;
                }
                if (!vc.equals(VirtualColumn.RAWDATASIZE)) continue;
                current = 0L;
                SerDeStats stats = this.deserializer.getSerDeStats();
                if (stats != null) {
                    current = stats.getRawDataSize();
                }
                if ((old = (LongWritable)this.vcValues[i]) == null) {
                    old = new LongWritable(current);
                    this.vcValues[i] = old;
                    continue;
                }
                if (current == old.get()) continue;
                old.set(current);
            }
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public String getName() {
        return "MAP";
    }

    @Override
    public OperatorType getType() {
        return null;
    }

    private static class MapOpCtx {
        boolean isPartitioned;
        StructObjectInspector rawRowObjectInspector;
        StructObjectInspector partObjectInspector;
        StructObjectInspector rowObjectInspector;
        Object[] rowWithPart;
        Deserializer deserializer;
        public String tableName;
        public String partName;

        public MapOpCtx(boolean isPartitioned, StructObjectInspector rowObjectInspector, StructObjectInspector rawRowObjectInspector, StructObjectInspector partObjectInspector, Object[] rowWithPart, Deserializer deserializer) {
            this.isPartitioned = isPartitioned;
            this.rowObjectInspector = rowObjectInspector;
            this.rawRowObjectInspector = rawRowObjectInspector;
            this.partObjectInspector = partObjectInspector;
            this.rowWithPart = rowWithPart;
            this.deserializer = deserializer;
        }

        public boolean isPartitioned() {
            return this.isPartitioned;
        }

        public StructObjectInspector getRowObjectInspector() {
            return this.rowObjectInspector;
        }

        public Object[] getRowWithPart() {
            return this.rowWithPart;
        }

        public Deserializer getDeserializer() {
            return this.deserializer;
        }
    }

    private static class MapInputPath {
        String path;
        String alias;
        Operator<? extends Serializable> op;

        public MapInputPath(String path, String alias, Operator<? extends Serializable> op) {
            this.path = path;
            this.alias = alias;
            this.op = op;
        }

        public boolean equals(Object o) {
            if (o instanceof MapInputPath) {
                MapInputPath mObj = (MapInputPath)o;
                if (mObj == null) {
                    return false;
                }
                return this.path.equals(mObj.path) && this.alias.equals(mObj.alias) && this.op.equals(mObj.op);
            }
            return false;
        }

        public int hashCode() {
            int ret = this.path == null ? 0 : this.path.hashCode();
            ret += this.alias == null ? 0 : this.alias.hashCode();
            return ret += this.op == null ? 0 : this.op.hashCode();
        }

        public Operator<? extends Serializable> getOp() {
            return this.op;
        }

        public void setOp(Operator<? extends Serializable> op) {
            this.op = op;
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS;

    }
}

