/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.NewMemberOrSetDialog;
import rex.graphics.mdxeditor.mdxbuilder.dnd.TransferableMdxBuilderTreeNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTAxisNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgAcceptAllStringNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTCalculatedMemberNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTCellPropertyNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNamedSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTWithMembersNode
extends DefaultMBTAxisNode
implements Serializable,
LanguageChangedListener {
    static ImageIcon icon = S.getAppIcon("MBTWithMembersNode.gif");
    private static String childrenIndent = "  ";

    public MBTWithMembersNode(String _axisCaption) {
        super(_axisCaption, false);
        I18n.addOnLanguageChangedListener(this);
    }

    public String getMdx(String indent) {
        if (this.getChildren() == null) {
            return "";
        }
        String mdx = indent + "WITH ";
        for (int i = 0; i < this.getChildren().size(); ++i) {
            mdx = mdx + "\n" + indent + this.getChild(i).getMdx(indent + childrenIndent);
        }
        return mdx;
    }

    void setAcceptableFlavorsArray() {
        this.acceptableFlavorsMimeTypes = new String[]{TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_DIMENSION_FLAVOR_STRING};
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public String[] getPopUpActionList() {
        return new String[]{MBTPopUpActions.DELETE_CHILDREN};
    }

    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
        if (droppedData instanceof DimensionTreeElement) {
            NewMemberOrSetDialog dialog = new NewMemberOrSetDialog(null);
            if (dialog.getName().equals("")) {
                return;
            }
            if (dialog.selected().equals(NewMemberOrSetDialog.MEMBERS_SELECTED)) {
                MBTCalculatedMemberNode calcMembNode = new MBTCalculatedMemberNode(((DimensionTreeElement)droppedData).getUniqueName(), dialog.getName());
                MBTArgAcceptAllStringNode valExprNode = new MBTArgAcceptAllStringNode("<value expression>");
                MBTCellPropertyNode cellProperties = new MBTCellPropertyNode();
                this.addChild(calcMembNode);
                calcMembNode.addChild(valExprNode);
                calcMembNode.addChild(cellProperties);
                DefaultMutableTreeNode treeCalcMemberNode = new DefaultMutableTreeNode(calcMembNode);
                treeModel.insertNodeInto(treeCalcMemberNode, containerNode, containerNode.getChildCount());
                treeModel.insertNodeInto(new DefaultMutableTreeNode(valExprNode), treeCalcMemberNode, treeCalcMemberNode.getChildCount());
                treeModel.insertNodeInto(new DefaultMutableTreeNode(cellProperties), treeCalcMemberNode, treeCalcMemberNode.getChildCount());
            } else {
                MBTNamedSetNode namedSetNode = new MBTNamedSetNode(dialog.getName());
                this.addChild(namedSetNode);
                DefaultMutableTreeNode treeNamedSetNode = new DefaultMutableTreeNode(namedSetNode);
                treeModel.insertNodeInto(treeNamedSetNode, containerNode, containerNode.getChildCount());
            }
        }
    }

    public void handleMemberDropFromQuery(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel, String calculatedMemberName, String formula, String format) {
        if (droppedData instanceof DimensionTreeElement) {
            MBTCalculatedMemberNode calcMembNode = new MBTCalculatedMemberNode(((DimensionTreeElement)droppedData).getUniqueName(), calculatedMemberName);
            MBTArgAcceptAllStringNode valExprNode = new MBTArgAcceptAllStringNode("<value expression>");
            valExprNode.setValue(formula);
            MBTCellPropertyNode cellProperties = new MBTCellPropertyNode();
            cellProperties.setCellProperty(format);
            this.addChild(calcMembNode);
            calcMembNode.addChild(valExprNode);
            calcMembNode.addChild(cellProperties);
            DefaultMutableTreeNode treeCalcMemberNode = new DefaultMutableTreeNode(calcMembNode);
            treeModel.insertNodeInto(treeCalcMemberNode, containerNode, containerNode.getChildCount());
            treeModel.insertNodeInto(new DefaultMutableTreeNode(valExprNode), treeCalcMemberNode, treeCalcMemberNode.getChildCount());
            treeModel.insertNodeInto(new DefaultMutableTreeNode(cellProperties), treeCalcMemberNode, treeCalcMemberNode.getChildCount());
        }
    }

    public DefaultMutableTreeNode handleSetDropFromQuery(DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel, String calculatedMemberName) {
        MBTNamedSetNode namedSetNode = new MBTNamedSetNode(calculatedMemberName);
        this.addChild(namedSetNode);
        DefaultMutableTreeNode treeNamedSetNode = new DefaultMutableTreeNode(namedSetNode);
        treeModel.insertNodeInto(treeNamedSetNode, containerNode, containerNode.getChildCount());
        return treeNamedSetNode;
    }

    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.DELETE_CHILDREN, I18n.getString("menu.deleteChildren"));
    }
}

