/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jrx;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class TextExportParametersPanel
extends AbstractExportParametersPanel {
    private JCheckBox jCheckBoxAddFormFeed;
    private JLabel jLabelBIDIPrefix;
    private JLabel jLabelDefault3;
    private JLabel jLabelDefault4;
    private JLabel jLabelDisplayWidthProviderFactory;
    private JLabel jLabelPageHeight;
    private JLabel jLabelPageWidth;
    private JLabel jLabelTitle;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerPageHeight;
    private JSpinner jSpinnerPageWidth;
    private JTextField jTextFieldBIDIPrefix;
    private JTextField jTextFieldDisplayWidthProviderFactory;

    public TextExportParametersPanel() {
        this.initComponents();
        ChangeListener snmcl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TextExportParametersPanel.this.notifyChange();
            }
        };
        SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerPageWidth.setModel(snm);
        snm.addChangeListener(snmcl);
        snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerPageHeight.setModel(snm);
        snm.addChangeListener(snmcl);
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }
        };
        this.jTextFieldBIDIPrefix.getDocument().addDocumentListener(textfieldListener);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelTitle.setText(I18n.getString((String)"IReportTextExportParametersPanel.jLabelTitle.text"));
        this.jLabelPageWidth.setText(I18n.getString((String)"TextExportParametersPanel.jLabelPageWidth.text"));
        this.jLabelPageHeight.setText(I18n.getString((String)"TextExportParametersPanel.jLabelPageHeight.text"));
        this.jLabelBIDIPrefix.setText(I18n.getString((String)"IReportTextExportParametersPanel.jLabelBIDIPrefix.text"));
        this.jLabelDisplayWidthProviderFactory.setText(I18n.getString((String)"IReportTextExportParametersPanel.jLabelDisplayWidthProviderFactory.text"));
        this.jCheckBoxAddFormFeed.setText(I18n.getString((String)"IReportTextExportParametersPanel.jCheckBoxAddFormFeed.text"));
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabelPageWidth = new JLabel();
        this.jSpinnerPageWidth = new JSpinner();
        this.jLabelPageHeight = new JLabel();
        this.jSpinnerPageHeight = new JSpinner();
        this.jLabelBIDIPrefix = new JLabel();
        this.jTextFieldBIDIPrefix = new JTextField();
        this.jLabelDefault3 = new JLabel();
        this.jLabelDefault4 = new JLabel();
        this.jCheckBoxAddFormFeed = new JCheckBox();
        this.jLabelDisplayWidthProviderFactory = new JLabel();
        this.jTextFieldDisplayWidthProviderFactory = new JTextField();
        this.jLabelTitle.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitle.setText("Text (iReport) Export parameters");
        this.jLabelPageWidth.setText("Page Width");
        this.jLabelPageHeight.setText("Page Height");
        this.jLabelBIDIPrefix.setText("BIDI prefix");
        this.jLabelDefault3.setText("(0 to use default)");
        this.jLabelDefault4.setText("(0 to use default)");
        this.jCheckBoxAddFormFeed.setText("Add form feed");
        this.jCheckBoxAddFormFeed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextExportParametersPanel.this.jCheckBoxAddFormFeedActionPerformed(evt);
            }
        });
        this.jLabelDisplayWidthProviderFactory.setText("Display Width Provider Factory");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(215, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 420, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelBIDIPrefix).addPreferredGap(0).add((Component)this.jTextFieldBIDIPrefix)).add(1, (Component)this.jCheckBoxAddFormFeed).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelPageWidth).add((Component)this.jLabelPageHeight)).add(28, 28, 28).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSpinnerPageWidth, -2, 45, -2).add((Component)this.jSpinnerPageHeight, -2, 45, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelDefault3).add((Component)this.jLabelDefault4)))).addContainerGap(191, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldDisplayWidthProviderFactory, -1, 400, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelDisplayWidthProviderFactory).addContainerGap(262, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPageWidth).add((Component)this.jSpinnerPageWidth, -2, -1, -2).add((Component)this.jLabelDefault3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPageHeight).add((Component)this.jSpinnerPageHeight, -2, -1, -2).add((Component)this.jLabelDefault4)).addPreferredGap(1).add((Component)this.jCheckBoxAddFormFeed).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelBIDIPrefix).add((Component)this.jTextFieldBIDIPrefix, -2, -1, -2)).add(18, 18, 18).add((Component)this.jLabelDisplayWidthProviderFactory).add(0, 0, 0).add((Component)this.jTextFieldDisplayWidthProviderFactory, -2, -1, -2).addContainerGap(182, Short.MAX_VALUE)));
    }

    private void jCheckBoxAddFormFeedActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    public void load() {
        Preferences pref = IReportManager.getPreferences();
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerPageHeight.getModel();
        model.setValue(pref.getInt("irtext.pageHeight", 0));
        model = (SpinnerNumberModel)this.jSpinnerPageWidth.getModel();
        model.setValue(pref.getInt("irtext.pageWidth", 0));
        this.jCheckBoxAddFormFeed.setSelected(pref.getBoolean("irtext.addFormFeed", true));
        this.jTextFieldBIDIPrefix.setText(pref.get("irtext.bidi", ""));
        this.jTextFieldDisplayWidthProviderFactory.setText(pref.get("irtext.displaywidthProviderFactory", ""));
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerPageHeight.getModel();
        pref.putInt("irtext.pageHeight", model.getNumber().intValue());
        model = (SpinnerNumberModel)this.jSpinnerPageWidth.getModel();
        pref.putInt("irtext.pageWidth", model.getNumber().intValue());
        pref.putBoolean("irtext.addFormFeed", this.jCheckBoxAddFormFeed.isSelected());
        pref.put("irtext.bidi", this.jTextFieldBIDIPrefix.getText());
        pref.put("irtext.displaywidthProviderFactory", this.jTextFieldDisplayWidthProviderFactory.getText());
    }

    public boolean valid() {
        return true;
    }

    public String getDisplayName() {
        return I18n.getString((String)"format.irtxt");
    }
}

