/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.PDFAsImage;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.XRLog;

public class ITextUserAgent
extends NaiveUserAgent {
    private static final int IMAGE_CACHE_CAPACITY = 32;
    private SharedContext _sharedContext;
    private ITextOutputDevice _outputDevice;

    public ITextUserAgent(ITextOutputDevice outputDevice) {
        super(32);
        this._outputDevice = outputDevice;
    }

    public ImageResource getImageResource(String uri) {
        InputStream is;
        ImageResource resource = null;
        resource = (ImageResource)this._imageCache.get(uri = this.resolveURI(uri));
        if (resource == null && (is = this.resolveAndOpenStream(uri)) != null) {
            try {
                URL url = new URL(uri);
                if (url.getPath() != null && url.getPath().toLowerCase().endsWith(".pdf")) {
                    PdfReader reader = this._outputDevice.getReader(url);
                    PDFAsImage image = new PDFAsImage(url);
                    Rectangle rect = reader.getPageSizeWithRotation(1);
                    image.setInitialWidth(rect.width() * this._outputDevice.getDotsPerPoint());
                    image.setInitialHeight(rect.height() * this._outputDevice.getDotsPerPoint());
                    resource = new ImageResource(image);
                } else {
                    Image image = Image.getInstance((URL)url);
                    this.scaleToOutputResolution(image);
                    resource = new ImageResource(new ITextFSImage(image));
                }
                this._imageCache.put(uri, resource);
            }
            catch (IOException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + uri + "'", e);
            }
            catch (BadElementException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + uri + "'", e);
            }
        }
        if (resource == null) {
            resource = new ImageResource(null);
        }
        return resource;
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this._sharedContext.getDotsPerPixel();
        image.scaleAbsolute(image.plainWidth() * factor, image.plainHeight() * factor);
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void setSharedContext(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
    }
}

