/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.JDBCNBConnection;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.ConfigurablePlainDocument;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.ValidationUtils;
import com.jaspersoft.ireport.jasperserver.ui.resources.DatasourceTableCellRenderer;
import com.jaspersoft.ireport.jasperserver.ui.resources.VirtualDatasourceItemDialog;
import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.openide.util.NbBundle;

public class DataSourceDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder datasourceResource = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private boolean doNotStore = false;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private JButton jButtonAddParameter;
    private JButton jButtonClose;
    private JButton jButtonImportConnection;
    private JButton jButtonModParameter;
    private JButton jButtonRemParameter;
    private JButton jButtonSave;
    private JComboBox jComboBox1;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelBeanMethod;
    private JLabel jLabelBeanName;
    private JLabel jLabelDescription;
    private JLabel jLabelDriver;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelPassword;
    private JLabel jLabelPassword1;
    private JLabel jLabelServiceName;
    private JLabel jLabelServiceName1;
    private JLabel jLabelURL;
    private JLabel jLabelURL1;
    private JLabel jLabelUriString;
    private JLabel jLabelUsername;
    private JLabel jLabelUsername1;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelBeanDataSource;
    private JPanel jPanelDatasource;
    private JPanel jPanelHadoopHive;
    private JPanel jPanelJDBC;
    private JPanel jPanelJNDI;
    private JPanel jPanelMongoDB;
    private JPanel jPanelVirtualDatasource;
    private JPasswordField jPasswordField;
    private JPasswordField jPasswordFieldMongoDB;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableDatasetParameters;
    private JTextField jTextFieldBeanMethod;
    private JTextField jTextFieldBeanName;
    private JTextField jTextFieldDriver;
    private JTextField jTextFieldHiveJDBCUrl;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldMongoDBURI;
    private JTextField jTextFieldMongoDBUsername;
    private JTextField jTextFieldName;
    private JTextField jTextFieldServiceName;
    private JTextField jTextFieldURL;
    private JTextField jTextFieldUriString;
    private JTextField jTextFieldUsername;

    public DataSourceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DataSourceDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString((String)"Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString((String)"Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                DataSourceDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                DataSourceDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                DataSourceDialog.this.updateSaveButton();
            }
        };
        this.jTextFieldName.setDocument((Document)new ConfigurablePlainDocument(100));
        this.jTextFieldLabel.setDocument((Document)new ConfigurablePlainDocument(100));
        this.jEditorPaneDescription.setDocument((Document)new ConfigurablePlainDocument(250));
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldDriver.getDocument().addDocumentListener(changesListener);
        this.jTextFieldURL.getDocument().addDocumentListener(changesListener);
        this.jTextFieldUsername.getDocument().addDocumentListener(changesListener);
        this.jTextFieldServiceName.getDocument().addDocumentListener(changesListener);
        this.jPasswordField.getDocument().addDocumentListener(changesListener);
        this.jTextFieldBeanName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldHiveJDBCUrl.getDocument().addDocumentListener(changesListener);
        this.jTextFieldMongoDBURI.getDocument().addDocumentListener(changesListener);
        this.jTextFieldMongoDBUsername.getDocument().addDocumentListener(changesListener);
        this.jPasswordFieldMongoDB.getDocument().addDocumentListener(changesListener);
        this.applyI18n();
        this.jTextFieldName.requestFocusInWindow();
        this.jComboBox1.setModel(new DefaultComboBoxModel<Tag>(new Tag[]{new Tag((Object)this.jPanelJDBC, this.jPanelJDBC.getName()), new Tag((Object)this.jPanelJNDI, this.jPanelJNDI.getName()), new Tag((Object)this.jPanelBeanDataSource, this.jPanelBeanDataSource.getName()), new Tag((Object)this.jPanelVirtualDatasource, this.jPanelVirtualDatasource.getName()), new Tag((Object)this.jPanelHadoopHive, this.jPanelHadoopHive.getName()), new Tag((Object)this.jPanelMongoDB, this.jPanelMongoDB.getName())}));
        this.jComboBox1.setSelectedIndex(0);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableDatasetParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataSourceDialog.this.jTableDatasetParametersListSelectionValueChanged(e);
            }
        });
        this.jTableDatasetParameters.getColumnModel().getColumn(0).setCellRenderer(new DatasourceTableCellRenderer());
        ((DefaultTableModel)this.jTableDatasetParameters.getModel()).addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tme) {
                DataSourceDialog.this.updateSaveButton();
            }
        });
    }

    public void jTableDatasetParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableDatasetParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameter.setEnabled(true);
            this.jButtonRemParameter.setEnabled(this.jTableDatasetParameters.getRowCount() > 0);
        } else {
            this.jButtonModParameter.setEnabled(false);
            this.jButtonRemParameter.setEnabled(false);
        }
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("dataSourceDialog.buttonCancel", "Cancel"));
        this.jButtonImportConnection.setText(JasperServerManager.getString("dataSourceDialog.buttonImportConnection", "Import from iReport"));
        this.jButtonSave.setText(JasperServerManager.getString("dataSourceDialog.buttonSave", "Save"));
        this.jLabel1.setText(JasperServerManager.getString("dataSourceDialog.title", "Data Source"));
        this.jLabelBeanMethod.setText(JasperServerManager.getString("dataSourceDialog.labelBeanMethod", "Bean Method"));
        this.jLabelBeanName.setText(JasperServerManager.getString("dataSourceDialog.labelBeanName", "Bean Name"));
        this.jLabelDescription.setText(JasperServerManager.getString("dataSourceDialog.labelDescription", "Description"));
        this.jLabelDriver.setText(JasperServerManager.getString("dataSourceDialog.labelDriver", "Driver"));
        this.jLabelLabel.setText(JasperServerManager.getString("dataSourceDialog.labelLabel", "Label"));
        this.jLabelName.setText(JasperServerManager.getString("dataSourceDialog.labelName", "Name"));
        this.jLabelUriString.setText(JasperServerManager.getString("dataSourceDialog.labelParentFolder", "Parent folder"));
        this.jLabelPassword.setText(JasperServerManager.getString("dataSourceDialog.labelPassword", "Password"));
        this.jLabelServiceName.setText(JasperServerManager.getString("dataSourceDialog.labelServiceName", "Service Name"));
        this.jLabelURL.setText(JasperServerManager.getString("dataSourceDialog.labelURL", "URL"));
        this.jLabelUsername.setText(JasperServerManager.getString("dataSourceDialog.labelUsername", "Username"));
        this.jTabbedPane1.setTitleAt(0, JasperServerManager.getString("dataSourceDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, JasperServerManager.getString("dataSourceDialog.tabDetails", "Data Source details"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            boolean ok = false;
            Tag selectedPanel = (Tag)this.jComboBox1.getSelectedItem();
            if (selectedPanel.getValue() == this.jPanelJDBC && this.jTextFieldDriver.getText().length() > 0 && this.jTextFieldURL.getText().length() > 0 && this.jTextFieldUsername.getText().length() > 0) {
                ok = true;
            } else if (selectedPanel.getValue() == this.jPanelJNDI && this.jTextFieldServiceName.getText().length() > 0) {
                ok = true;
            } else if (selectedPanel.getValue() == this.jPanelBeanDataSource && this.jTextFieldBeanName.getText().length() > 0) {
                ok = true;
            } else if (selectedPanel.getValue() == this.jPanelVirtualDatasource && this.jTableDatasetParameters.getRowCount() > 0) {
                ok = true;
            } else if (selectedPanel.getValue() == this.jPanelHadoopHive && this.jTextFieldHiveJDBCUrl.getText().length() > 0) {
                ok = true;
            } else if (selectedPanel.getValue() == this.jPanelMongoDB && this.jTextFieldMongoDBURI.getText().length() > 0) {
                ok = true;
            }
            this.jButtonSave.setEnabled(ok);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelJDBC = new JPanel();
        this.jLabelDriver = new JLabel();
        this.jTextFieldDriver = new JTextField();
        this.jLabelURL = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jLabelUsername = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jButtonImportConnection = new JButton();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanelJNDI = new JPanel();
        this.jLabelServiceName = new JLabel();
        this.jTextFieldServiceName = new JTextField();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanelBeanDataSource = new JPanel();
        this.jLabelBeanName = new JLabel();
        this.jTextFieldBeanName = new JTextField();
        this.jLabelBeanMethod = new JLabel();
        this.jTextFieldBeanMethod = new JTextField();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanelVirtualDatasource = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableDatasetParameters = new JTable();
        this.jPanel10 = new JPanel();
        this.jButtonAddParameter = new JButton();
        this.jButtonModParameter = new JButton();
        this.jButtonRemParameter = new JButton();
        this.jPanelHadoopHive = new JPanel();
        this.jLabelServiceName1 = new JLabel();
        this.jTextFieldHiveJDBCUrl = new JTextField();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanelMongoDB = new JPanel();
        this.jLabelURL1 = new JLabel();
        this.jTextFieldMongoDBURI = new JTextField();
        this.jLabelUsername1 = new JLabel();
        this.jTextFieldMongoDBUsername = new JTextField();
        this.jLabelPassword1 = new JLabel();
        this.jPasswordFieldMongoDB = new JPasswordField();
        this.filler5 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanelDatasource = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.jPanelJDBC.setName("JDBC");
        this.jPanelJDBC.setLayout(new GridBagLayout());
        this.jLabelDriver.setText("Driver");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanelJDBC.add((Component)this.jLabelDriver, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 8);
        this.jPanelJDBC.add((Component)this.jTextFieldDriver, gridBagConstraints);
        this.jLabelURL.setText("URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelJDBC.add((Component)this.jLabelURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelJDBC.add((Component)this.jTextFieldURL, gridBagConstraints);
        this.jLabelUsername.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelJDBC.add((Component)this.jLabelUsername, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelJDBC.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabelPassword.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelJDBC.add((Component)this.jLabelPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelJDBC.add((Component)this.jPasswordField, gridBagConstraints);
        this.jButtonImportConnection.setText("Import from iReport");
        this.jButtonImportConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonImportConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.jPanelJDBC.add((Component)this.jButtonImportConnection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelJDBC.add((Component)this.filler3, gridBagConstraints);
        this.jPanelJNDI.setName("JNDI");
        this.jPanelJNDI.setLayout(new GridBagLayout());
        this.jLabelServiceName.setText("Service Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelJNDI.add((Component)this.jLabelServiceName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelJNDI.add((Component)this.jTextFieldServiceName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelJNDI.add((Component)this.filler2, gridBagConstraints);
        this.jPanelBeanDataSource.setName("Bean Data Source");
        this.jPanelBeanDataSource.setLayout(new GridBagLayout());
        this.jLabelBeanName.setText("Bean Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelBeanDataSource.add((Component)this.jLabelBeanName, gridBagConstraints);
        this.jTextFieldBeanName.setToolTipText("Name of configured bean");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelBeanDataSource.add((Component)this.jTextFieldBeanName, gridBagConstraints);
        this.jLabelBeanMethod.setText("Bean Method");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelBeanDataSource.add((Component)this.jLabelBeanMethod, gridBagConstraints);
        this.jTextFieldBeanMethod.setToolTipText("Name of method on configured bean (optional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelBeanDataSource.add((Component)this.jTextFieldBeanMethod, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelBeanDataSource.add((Component)this.filler1, gridBagConstraints);
        this.jPanelVirtualDatasource.setName("Virtual Data Source");
        this.jPanelVirtualDatasource.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(300, 50));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 50));
        this.jTableDatasetParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Datasource ID", "URI"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableDatasetParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DataSourceDialog.this.jTableDatasetParametersMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableDatasetParameters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelVirtualDatasource.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel10.setMinimumSize(new Dimension(100, 10));
        this.jPanel10.setPreferredSize(new Dimension(100, 69));
        this.jPanel10.setLayout(new GridBagLayout());
        this.jButtonAddParameter.setText(NbBundle.getMessage(DataSourceDialog.class, (String)"DataSourceDialog.jButtonAddParameter.text"));
        this.jButtonAddParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonAddParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jButtonAddParameter, gridBagConstraints);
        this.jButtonModParameter.setText(NbBundle.getMessage(DataSourceDialog.class, (String)"DataSourceDialog.jButtonModParameter.text"));
        this.jButtonModParameter.setEnabled(false);
        this.jButtonModParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonModParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jButtonModParameter, gridBagConstraints);
        this.jButtonRemParameter.setText(NbBundle.getMessage(DataSourceDialog.class, (String)"DataSourceDialog.jButtonRemParameter.text"));
        this.jButtonRemParameter.setEnabled(false);
        this.jButtonRemParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonRemParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel10.add((Component)this.jButtonRemParameter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelVirtualDatasource.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanelHadoopHive.setName("Hadoop-Hive Data Source");
        this.jPanelHadoopHive.setLayout(new GridBagLayout());
        this.jLabelServiceName1.setText("Hive's JDBC URL ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelHadoopHive.add((Component)this.jLabelServiceName1, gridBagConstraints);
        this.jTextFieldHiveJDBCUrl.setText("jdbc:hive://hostname:10000/default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelHadoopHive.add((Component)this.jTextFieldHiveJDBCUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelHadoopHive.add((Component)this.filler4, gridBagConstraints);
        this.jPanelMongoDB.setName("MongoDB Data Source");
        this.jPanelMongoDB.setLayout(new GridBagLayout());
        this.jLabelURL1.setText("MongoDB URI ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelMongoDB.add((Component)this.jLabelURL1, gridBagConstraints);
        this.jTextFieldMongoDBURI.setText("mongodb://hostname:27017/database");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelMongoDB.add((Component)this.jTextFieldMongoDBURI, gridBagConstraints);
        this.jLabelUsername1.setText("Username (optional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelMongoDB.add((Component)this.jLabelUsername1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelMongoDB.add((Component)this.jTextFieldMongoDBUsername, gridBagConstraints);
        this.jLabelPassword1.setText("Password (optional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelMongoDB.add((Component)this.jLabelPassword1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanelMongoDB.add((Component)this.jPasswordFieldMongoDB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelMongoDB.add((Component)this.filler5, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setTitle("DataSource");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_new.png")));
        this.jLabel1.setText("Datasource");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setPreferredSize(new Dimension(400, 185));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("ID");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setText("Datasource Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel3.add((Component)this.jComboBox1, gridBagConstraints);
        this.jPanelDatasource.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jPanelDatasource.setMinimumSize(new Dimension(12, 300));
        this.jPanelDatasource.setPreferredSize(new Dimension(100, 300));
        this.jPanelDatasource.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jPanelDatasource, gridBagConstraints);
        this.jTabbedPane1.addTab("Datasource details", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataSourceDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonImportConnectionActionPerformed(ActionEvent evt) {
        List iReportConnections = IReportManager.getInstance().getConnections();
        Vector<IReportConnection> validConnections = new Vector<IReportConnection>();
        for (IReportConnection conn : iReportConnections) {
            if (!(conn instanceof JDBCConnection) && !(conn instanceof JDBCNBConnection)) continue;
            validConnections.add(conn);
        }
        if (validConnections.size() == 0) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getString("dataSourceDialog.message.noJDBCconfigured", "No JDBC connections currently configured in iReport."));
            return;
        }
        Object[] connections = new IReportConnection[validConnections.size()];
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = (IReportConnection)validConnections.elementAt(i);
        }
        IReportConnection selectedCon = (IReportConnection)JOptionPane.showInputDialog(this, JasperServerManager.getString("dataSourceDialog.message.selectJDBC", "Select a JDBC datasource:"), JasperServerManager.getString("dataSourceDialog.message.import", "Import..."), 3, null, connections, connections[0]);
        if (selectedCon != null) {
            DatabaseConnection dbconn;
            if (selectedCon instanceof JDBCConnection) {
                this.jTextFieldDriver.setText(((JDBCConnection)selectedCon).getJDBCDriver());
                this.jTextFieldURL.setText(((JDBCConnection)selectedCon).getUrl());
                this.jTextFieldUsername.setText(((JDBCConnection)selectedCon).getUsername());
                this.jPasswordField.setText(((JDBCConnection)selectedCon).getPassword());
            } else if (selectedCon instanceof JDBCNBConnection && (dbconn = ((JDBCNBConnection)selectedCon).getDatabaseConnectionObject()) != null) {
                this.jTextFieldDriver.setText(dbconn.getDriverClass());
                this.jTextFieldURL.setText(dbconn.getDatabaseURL());
                this.jTextFieldUsername.setText(dbconn.getUser());
                this.jPasswordField.setText(dbconn.getPassword());
            }
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            ResourceDescriptor rd = new ResourceDescriptor();
            ValidationUtils.validateName(this.jTextFieldName.getText());
            ValidationUtils.validateLabel(this.jTextFieldLabel.getText());
            ValidationUtils.validateDesc(this.jEditorPaneDescription.getText());
            rd.setDescription(this.jEditorPaneDescription.getText().trim());
            rd.setName(this.jTextFieldName.getText());
            String uri = this.getParentFolder();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + this.jTextFieldName.getText();
            rd.setUriString(uri);
            rd.setLabel(this.jTextFieldLabel.getText().trim());
            rd.setParentFolder(this.getParentFolder());
            rd.setIsNew(this.datasourceResource == null);
            Tag selectedPanel = (Tag)this.jComboBox1.getSelectedItem();
            if (selectedPanel.getValue() == this.jPanelJDBC) {
                rd.setWsType("jdbc");
                rd.setDriverClass(this.jTextFieldDriver.getText());
                rd.setConnectionUrl(this.jTextFieldURL.getText());
                rd.setUsername(this.jTextFieldUsername.getText());
                rd.setPassword(new String(this.jPasswordField.getPassword()));
            } else if (selectedPanel.getValue() == this.jPanelJNDI) {
                rd.setWsType("jndi");
                rd.setJndiName(this.jTextFieldServiceName.getText());
            } else if (selectedPanel.getValue() == this.jPanelBeanDataSource) {
                rd.setWsType("bean");
                rd.setBeanName(this.jTextFieldBeanName.getText());
                rd.setBeanMethod(this.jTextFieldBeanMethod.getText());
            } else if (selectedPanel.getValue() == this.jPanelVirtualDatasource) {
                rd.setWsType("virtual");
                rd.setBeanName(this.jTextFieldBeanName.getText());
                rd.setBeanMethod(this.jTextFieldBeanMethod.getText());
                for (int i = 0; i < this.jTableDatasetParameters.getRowCount(); ++i) {
                    rd.getChildren().add((ResourceDescriptor)this.jTableDatasetParameters.getValueAt(i, 0));
                }
            } else if (selectedPanel.getValue() == this.jPanelHadoopHive) {
                rd.setWsType("custom");
                rd.setResourceProperty("PROP_DATASOURCE_CUSTOM_SERVICE_CLASS", "com.jaspersoft.hadoop.hive.jasperserver.HiveDataSourceService");
                HashMap<String, String> customPropertyMap = new HashMap<String, String>();
                customPropertyMap.put("jdbcURL", this.jTextFieldHiveJDBCUrl.getText().trim());
                customPropertyMap.put("_cds_name", "HiveDataSource");
                rd.setPropertyMap(customPropertyMap);
            } else if (selectedPanel.getValue() == this.jPanelMongoDB) {
                rd.setWsType("custom");
                rd.setResourceProperty("PROP_DATASOURCE_CUSTOM_SERVICE_CLASS", "com.jaspersoft.mongodb.jasperserver.MongoDbDataSourceService");
                HashMap<String, String> customPropertyMap = new HashMap<String, String>();
                customPropertyMap.put("mongoURI", this.jTextFieldMongoDBURI.getText().trim());
                customPropertyMap.put("_cds_name", "MongoDbDataSource");
                if (this.jTextFieldMongoDBUsername.getText().trim().length() > 0) {
                    customPropertyMap.put("username", this.jTextFieldMongoDBUsername.getText().trim());
                }
                if (this.jPasswordFieldMongoDB.getPassword().length > 0) {
                    customPropertyMap.put("password", new String(this.jPasswordFieldMongoDB.getPassword()));
                    System.out.println("Storing pass: " + new String(this.jPasswordFieldMongoDB.getPassword()));
                }
                rd.setPropertyMap(customPropertyMap);
            }
            this.newResourceDescriptor = !this.doNotStore ? this.getServer().getWSClient().addOrModifyResource(rd, null) : rd;
            this.setDialogResult(0);
            if (this.datasourceResource != null) {
                this.datasourceResource.setDescriptor(this.newResourceDescriptor);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.updateDatasourceType();
    }

    private void jTableDatasetParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1 && this.jTableDatasetParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameterActionPerformed(null);
        }
    }

    private void jButtonAddParameterActionPerformed(ActionEvent evt) {
        HashMap<String, ResourceDescriptor> map = new HashMap<String, ResourceDescriptor>();
        for (int i = 0; i < this.jTableDatasetParameters.getRowCount(); ++i) {
            ResourceDescriptor dsRd = (ResourceDescriptor)this.jTableDatasetParameters.getValueAt(i, 0);
            map.put(dsRd.getResourcePropertyValue("PROP_DATASOURCE_SUB_DS_ID"), dsRd);
        }
        VirtualDatasourceItemDialog dialog = new VirtualDatasourceItemDialog((Dialog)this, true);
        dialog.setServer(this.getServer());
        dialog.setExistingResourceDescriptors(map);
        dialog.setVisible(true);
        if (dialog.getDialogResult() == 0) {
            ResourceDescriptor newDsRd = dialog.getResourceDescriptor();
            try {
                DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
                dtm.addRow(new Object[]{newDsRd, newDsRd.getResourcePropertyValue("PROP_REFERENCE_URI")});
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jButtonModParameterActionPerformed(ActionEvent evt) {
        HashMap<String, ResourceDescriptor> map = new HashMap<String, ResourceDescriptor>();
        for (int i = 0; i < this.jTableDatasetParameters.getRowCount(); ++i) {
            ResourceDescriptor dsRd = (ResourceDescriptor)this.jTableDatasetParameters.getValueAt(i, 0);
            map.put(dsRd.getResourcePropertyValue("PROP_DATASOURCE_SUB_DS_ID"), dsRd);
        }
        VirtualDatasourceItemDialog dialog = new VirtualDatasourceItemDialog((Dialog)this, true);
        int rowNumber = this.jTableDatasetParameters.getSelectedRow();
        ResourceDescriptor oldRd = (ResourceDescriptor)this.jTableDatasetParameters.getValueAt(rowNumber, 0);
        dialog.setServer(this.getServer());
        dialog.setResourceDescriptor(oldRd);
        dialog.setExistingResourceDescriptors(map);
        dialog.setVisible(true);
        if (dialog.getDialogResult() == 0) {
            ResourceDescriptor newRd = dialog.getResourceDescriptor();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
            dtm.setValueAt(newRd, rowNumber, 0);
            dtm.setValueAt(newRd.getResourcePropertyValue("PROP_REFERENCE_URI"), rowNumber, 1);
            this.jTableDatasetParameters.updateUI();
        }
    }

    private void jButtonRemParameterActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
        while (this.jTableDatasetParameters.getSelectedRowCount() > 0 && this.jTableDatasetParameters.getRowCount() > 0) {
            int i = this.jTableDatasetParameters.getSelectedRow();
            dtm.removeRow(i);
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.datasourceResource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
            this.jTextFieldName.setEditable(false);
            this.jTextFieldName.setOpaque(false);
        }
    }

    public void setResource(ResourceDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.setTitle(JasperServerManager.getFormattedString("properties.title", "{0} - Properties", new Object[]{descriptor.getName()}));
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        if (descriptor.getWsType().equals("jdbc")) {
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBox1, (Object)this.jPanelJDBC);
            this.jTextFieldDriver.setText(descriptor.getDriverClass());
            this.jTextFieldURL.setText(descriptor.getConnectionUrl());
            this.jTextFieldUsername.setText(descriptor.getUsername());
            this.jPasswordField.setText(descriptor.getPassword());
        } else if (descriptor.getWsType().equals("jndi")) {
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBox1, (Object)this.jPanelJNDI);
            this.jTextFieldServiceName.setText(descriptor.getJndiName());
        } else if (descriptor.getWsType().equals("bean")) {
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBox1, (Object)this.jPanelBeanDataSource);
            this.jTextFieldBeanName.setText(descriptor.getBeanName());
            this.jTextFieldBeanMethod.setText(descriptor.getBeanMethod() != null && descriptor.getBeanMethod().trim().length() > 0 ? descriptor.getBeanMethod() : "");
        } else if (descriptor.getWsType().equals("virtual")) {
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBox1, (Object)this.jPanelVirtualDatasource);
            ((DefaultTableModel)this.jTableDatasetParameters.getModel()).setRowCount(0);
            for (int i = 0; i < descriptor.getChildren().size(); ++i) {
                ResourceDescriptor childRd = (ResourceDescriptor)descriptor.getChildren().get(i);
                ((DefaultTableModel)this.jTableDatasetParameters.getModel()).addRow(new Object[]{childRd, childRd.getResourcePropertyValue("PROP_REFERENCE_URI")});
            }
            this.jTableDatasetParameters.updateUI();
        } else if (descriptor.getWsType().equals("custom") && descriptor.getResourcePropertyValue("PROP_DATASOURCE_CUSTOM_SERVICE_CLASS") != null && descriptor.getResourcePropertyValue("PROP_DATASOURCE_CUSTOM_SERVICE_CLASS").equals("com.jaspersoft.hadoop.hive.jasperserver.HiveDataSourceService")) {
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBox1, (Object)this.jPanelHadoopHive);
            Map props = descriptor.getPropertyMap();
            this.jTextFieldHiveJDBCUrl.setText((String)props.get("jdbcURL"));
        } else if (descriptor.getWsType().equals("custom") && descriptor.getResourcePropertyValue("PROP_DATASOURCE_CUSTOM_SERVICE_CLASS") != null && descriptor.getResourcePropertyValue("PROP_DATASOURCE_CUSTOM_SERVICE_CLASS").equals("com.jaspersoft.mongodb.jasperserver.MongoDbDataSourceService")) {
            Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBox1, (Object)this.jPanelMongoDB);
            Map props = descriptor.getPropertyMap();
            this.jTextFieldMongoDBURI.setText(Misc.nvl(props.get("mongoURI"), (String)""));
            this.jTextFieldMongoDBUsername.setText(Misc.nvl(props.get("username"), (String)""));
            this.jPasswordFieldMongoDB.setText(Misc.nvl(props.get("password"), (String)""));
        }
        this.updateDatasourceType();
        this.jComboBox1.setEnabled(false);
        this.updateSaveButton();
        this.jButtonSave.setText("Save");
    }

    public void updateDatasourceType() {
        Tag selectedPanel = (Tag)this.jComboBox1.getSelectedItem();
        if (selectedPanel != null) {
            this.jPanelDatasource.removeAll();
            this.jPanelDatasource.add((Component)((JComponent)selectedPanel.getValue()), "Center");
            this.jPanelDatasource.updateUI();
            this.updateSaveButton();
        }
    }

    public boolean isDoNotStore() {
        return this.doNotStore;
    }

    public void setDoNotStore(boolean doNotStore) {
        this.doNotStore = doNotStore;
    }
}

