/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes.dnd;

import com.jaspersoft.ireport.jasperserver.ui.RepositoryListCellRenderer;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class HighlightingPanel
extends JPanel {
    public static final int TYPE_COPY_REPLACE = 0;
    public static final int TYPE_DONT_COPY = 1;
    public static final int TYPE_COPY = 2;
    public static final int MODE_COPY = 1;
    public static final int MODE_MOVE = 2;
    boolean pressed = false;
    boolean over = false;
    private int mode = 1;
    Color originalBG = null;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private JLabel jLabel1CR;
    private JLabel jLabelDescription;
    private JLabel jLabelIconCR;
    private JLabel jLabelNameCR;
    private JLabel jLabelTitle;
    private JLabel jLabelUriCR;

    public HighlightingPanel() {
        this.initComponents();
        this.originalBG = this.getBackground();
        EmptyBorder border = new EmptyBorder(0, 0, 4, 4);
        this.setBorder(border);
    }

    public void setResource(ResourceDescriptor rd, int buttonType, String newName) {
        if (rd != null) {
            this.jLabelNameCR.setText("<html><b>" + rd.getLabel());
            this.jLabelUriCR.setText(rd.getUriString());
            this.jLabelIconCR.setIcon(RepositoryListCellRenderer.getResourceIcon(rd));
        }
        switch (buttonType) {
            case 0: {
                if (this.mode == 1) {
                    this.jLabelTitle.setText("<html><font size=\"4\">Copy and Replace");
                } else {
                    this.jLabelTitle.setText("<html><font size=\"4\">Move and Replace");
                }
                this.jLabelDescription.setText("Replace the resource in the destination folder with the resource you are copying:");
                break;
            }
            case 1: {
                if (this.mode == 1) {
                    this.jLabelTitle.setText("<html><font size=\"4\">Don't copy");
                } else {
                    this.jLabelTitle.setText("<html><font size=\"4\">Don't move");
                }
                this.jLabelDescription.setText("No resources will be changed. Leave this resource in the destination folder:");
                break;
            }
            case 2: {
                if (this.mode == 1) {
                    this.jLabelTitle.setText("<html><font size=\"4\">Copy, but keep both resources");
                    this.jLabelDescription.setText(new MessageFormat("The resource you are copying will be renamed \"{0}\"").format(new Object[]{newName}));
                } else {
                    this.jLabelTitle.setText("<html><font size=\"4\">Move, but keep both resources");
                    this.jLabelDescription.setText(new MessageFormat("The resource you are moving will be renamed \"{0}\"").format(new Object[]{newName}));
                }
                this.jLabelIconCR.setVisible(false);
                this.jLabelNameCR.setVisible(false);
                this.jLabelUriCR.setVisible(false);
            }
        }
    }

    public void bindActions() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof JComponent)) continue;
            c.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    HighlightingPanel.this.formMouseClicked(e);
                }
            });
        }
    }

    public void addActionListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireAction() {
        for (ActionListener listener : this.listeners) {
            ActionEvent event = new ActionEvent(this, 0, "");
            listener.actionPerformed(event);
        }
    }

    private void initComponents() {
        this.jLabelIconCR = new JLabel();
        this.jLabelUriCR = new JLabel();
        this.jLabelNameCR = new JLabel();
        this.jLabelDescription = new JLabel();
        this.jLabelTitle = new JLabel();
        this.jLabel1CR = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HighlightingPanel.this.formMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                HighlightingPanel.this.formMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                HighlightingPanel.this.formMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                HighlightingPanel.this.formMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                HighlightingPanel.this.formMouseReleased(evt);
            }
        });
        this.jLabelIconCR.setHorizontalAlignment(0);
        this.jLabelIconCR.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/unknow.png")));
        this.jLabelIconCR.setText(NbBundle.getMessage(HighlightingPanel.class, (String)"HighlightingPanel.jLabelIconCR.text"));
        this.jLabelIconCR.setBorder(new LineBorder(new Color(207, 206, 206), 1, true));
        this.jLabelUriCR.setText(NbBundle.getMessage(HighlightingPanel.class, (String)"HighlightingPanel.jLabelUriCR.text"));
        this.jLabelNameCR.setText(NbBundle.getMessage(HighlightingPanel.class, (String)"HighlightingPanel.jLabelNameCR.text"));
        this.jLabelDescription.setText(NbBundle.getMessage(HighlightingPanel.class, (String)"HighlightingPanel.jLabelDescription.text"));
        this.jLabelTitle.setForeground(new Color(0, 0, 153));
        this.jLabelTitle.setText(NbBundle.getMessage(HighlightingPanel.class, (String)"HighlightingPanel.jLabelTitle.text"));
        this.jLabel1CR.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/ui/nodes/dnd/arrow_right.png")));
        this.jLabel1CR.setText(NbBundle.getMessage(HighlightingPanel.class, (String)"HighlightingPanel.jLabel1CR.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1CR).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelIconCR, -2, 54, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelNameCR, -2, -1, -2).add((Component)this.jLabelUriCR, -2, -1, -2)).add(278, 278, 278)).add((Component)this.jLabelDescription).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle, -1, 188, Short.MAX_VALUE).add(212, 212, 212))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1CR).add((Component)this.jLabelTitle, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelDescription).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelNameCR, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelUriCR, -2, -1, -2)).add((Component)this.jLabelIconCR, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formMouseClicked(MouseEvent evt) {
        this.fireAction();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.over = true;
        this.repaint();
    }

    private void formMouseExited(MouseEvent evt) {
        this.over = false;
        this.repaint();
    }

    private void formMousePressed(MouseEvent evt) {
        EmptyBorder border = new EmptyBorder(4, 4, 0, 0);
        this.setBorder(border);
        this.pressed = true;
        this.repaint();
    }

    private void formMouseReleased(MouseEvent evt) {
        EmptyBorder border = new EmptyBorder(0, 0, 4, 4);
        this.setBorder(border);
        this.pressed = false;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.over && !this.pressed) {
            return;
        }
        RenderingHints ri = ((Graphics2D)g).getRenderingHints();
        Paint p = ((Graphics2D)g).getPaint();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() != null) {
            insets = this.getBorder().getBorderInsets(this);
        }
        GradientPaint gradient = new GradientPaint(new Point(insets.left, insets.top), new Color(255, 255, 255, 0), new Point(insets.left, this.getSize().height - insets.top - insets.bottom), this.pressed ? new Color(171, 217, 217) : new Color(191, 224, 224));
        ((Graphics2D)g).setPaint(gradient);
        ((Graphics2D)g).fillRoundRect(insets.left, insets.top, this.getSize().width - insets.left - insets.right - 1, this.getSize().height - insets.top - insets.bottom - 1, 20, 20);
        ((Graphics2D)g).setPaint(new Color(117, 198, 217));
        ((Graphics2D)g).drawRoundRect(insets.left, insets.top, this.getSize().width - insets.left - insets.right - 1, this.getSize().height - insets.top - insets.bottom - 1, 20, 20);
        ((Graphics2D)g).setRenderingHints(ri);
        ((Graphics2D)g).setPaint(p);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }
}

