/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.compiler.IReportCompiler;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.jasperserver.ActiveEditorTopComponentListener;
import com.jaspersoft.ireport.jasperserver.Encrypter;
import com.jaspersoft.ireport.jasperserver.FileResourceUpdatingListener;
import com.jaspersoft.ireport.jasperserver.JSDataProvider;
import com.jaspersoft.ireport.jasperserver.JSFileResolver;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JrxmlNotifier;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ResourceHandler;
import com.jaspersoft.ireport.jasperserver.ResourceMenuContributor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperServerManager {
    public static final int MAX_ID_LENGHT = 100;
    public static final int MAX_NAME_LENGHT = 100;
    private List<FileResourceUpdatingListener> resourceReplacingListeners = new ArrayList<FileResourceUpdatingListener>();
    private static JasperServerManager mainInstance = null;
    private static JrxmlNotifier jrxmlNotifier = null;
    public static String REQUIRED_VERSION = "";
    public static String CURRENT_VERSION = "";
    public static final String PROPERTY_CHECK_FOR_UPDATE = "PROPERTY_CHECK_FOR_UPDATE";
    public static final String PROPERTY_USE_PROXY = "PROPERTY_USE_PROXY";
    public static final String PROPERTY_PROXY_URL = "PROPERTY_PROXY_URL";
    public static final String PROPERTY_PROXY_USE_AUTH = "PROPERTY_PROXY_USE_AUTH";
    public static final String PROPERTY_PROXY_USERNAME = "PROPERTY_PROXY_USERNAME";
    public static final String PROPERTY_PROXY_PASSWORD = "PROPERTY_PROXY_PASSWORD";
    private List jServers = new ArrayList();
    private Properties properties = new Properties();
    private Properties brandingProperties = new Properties();
    private HashMap<String, RepositoryReportUnit> jrxmlReportUnitMap = new HashMap();
    private HashMap<String, JSDataProvider> dataProvidersMap = new HashMap();
    private static ResourceBundle oLanguage = null;
    private static Locale pluginLocale = null;

    public void addFileResourceUpdatingListener(FileResourceUpdatingListener listener) {
        this.resourceReplacingListeners.add(listener);
    }

    public void removeFileResourceUpdatingListener(FileResourceUpdatingListener listener) {
        this.resourceReplacingListeners.remove(listener);
    }

    public static JrxmlNotifier getJrxmlNotifier() {
        return jrxmlNotifier;
    }

    public static JasperServerManager getMainInstance() {
        if (mainInstance == null) {
            mainInstance = new JasperServerManager();
        }
        return mainInstance;
    }

    private JasperServerManager() {
        this.loadConfiguration();
        this.applyProxySettings();
        pluginLocale = Locale.getDefault();
        ActiveEditorTopComponentListener.getDefaultInstance();
        ActiveEditorTopComponentListener.startListening();
        jrxmlNotifier = new JrxmlNotifier();
        this.addFileResourceUpdatingListener(jrxmlNotifier);
        IReportCompiler.addCompileListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IReportCompiler compiler = (IReportCompiler)e.getSource();
                if (e.getID() == 1) {
                    JasperDesign jd = compiler.getJrxmlVisualView().getEditorSupport().getCurrentModel();
                    System.out.println("Setting up the file resolver...");
                    if (jd.getProperty("ireport.jasperserver.url") != null) {
                        List servers = JasperServerManager.this.getJServers();
                        for (JServer server : servers) {
                            if (!server.getUrl().equals(jd.getProperty("ireport.jasperserver.url"))) continue;
                            File jasperDir = FileUtil.toFile((FileObject)compiler.getFile().getParent());
                            if (!IReportManager.getPreferences().getBoolean("useReportDirectoryToCompile", true)) {
                                jasperDir = new File(IReportManager.getPreferences().get("reportDirectoryToCompile", "."));
                            }
                            ArrayList<File> resolverPath = new ArrayList<File>();
                            if (jasperDir.exists()) {
                                resolverPath.add(jasperDir);
                            }
                            resolverPath.add(new File("."));
                            JSFileResolver resolver = new JSFileResolver(resolverPath, server, jd);
                            if (resolver == null) continue;
                            compiler.getAdditionalParameters().put("REPORT_FILE_RESOLVER", resolver);
                            System.out.println("Added file resolver...");
                        }
                    }
                }
            }
        });
    }

    public void applyProxySettings() {
        Properties props = this.getProperties();
        System.getProperties().remove("proxySet");
        System.getProperties().remove("proxyHost");
        System.getProperties().remove("proxyPort");
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("http.proxyUser");
        System.getProperties().remove("http.proxyPassword");
        System.getProperties().remove("https.proxyHost");
        System.getProperties().remove("https.proxyPort");
        if (props.getProperty(PROPERTY_USE_PROXY, "false").equals("true")) {
            String urlProxy = props.getProperty(PROPERTY_PROXY_URL, "");
            String port = "8080";
            String server = urlProxy;
            if (urlProxy.indexOf(":") > 0) {
                port = urlProxy.substring(urlProxy.indexOf(":") + 1);
                server = urlProxy.substring(0, urlProxy.indexOf(":"));
            }
            System.getProperties().put("http.proxyHost", server);
            System.getProperties().put("http.proxyPort", port);
            if (props.getProperty(PROPERTY_PROXY_USE_AUTH, "false").equals("true")) {
                String userName = props.getProperty(PROPERTY_PROXY_USERNAME, "");
                String userPass = props.getProperty(PROPERTY_PROXY_PASSWORD, "");
                System.getProperties().put("http.proxyUser", userName);
                System.getProperties().put("http.proxyPassword", userPass);
            }
        }
    }

    public void loadConfiguration() {
        try {
            int i;
            this.setProperties(new Properties());
            Preferences prefs = NbPreferences.forModule(JasperServerManager.class);
            String[] keys = prefs.keys();
            Properties props = this.getProperties();
            for (i = 0; i < keys.length; ++i) {
                props.put(keys[i], prefs.get(keys[i], null));
            }
            i = 0;
            while (props.getProperty("server." + i + ".name") != null) {
                JServer server = new JServer();
                server.setName(props.getProperty("server." + i + ".name"));
                server.setUrl(props.getProperty("server." + i + ".url"));
                server.setUsername(props.getProperty("server." + i + ".username"));
                String pwd = null;
                if (props.getProperty("server." + i + ".password.enc") != null) {
                    Encrypter enc = new Encrypter(this.getBrandingProperties().getProperty("irplugin.encrypt.passwords.key", "54fj245vn3vfdsmce4mg0jvs"));
                    pwd = enc.decrypt(props.getProperty("server." + i + ".password.enc"));
                } else {
                    pwd = props.getProperty("server." + i + ".password");
                }
                server.setPassword(pwd);
                server.setLocale(Locale.getDefault().toString());
                this.getJServers().add(server);
                ++i;
            }
            this.addProperties("/com/jaspersoft/ireport/jasperserver/default.jasperserver_irplugin.properties", this.getBrandingProperties());
            this.addProperties("/com/jaspersoft/ireport/jasperserver/jasperserver_irplugin.properties", this.getBrandingProperties());
            REQUIRED_VERSION = this.getBrandingProperties().getProperty("irplugin.server.required.version");
            CURRENT_VERSION = this.getBrandingProperties().getProperty("irplugin.version");
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void addProperties(String resourceUri, Properties props) {
        try {
            InputStream is = this.getClass().getResourceAsStream(resourceUri);
            if (is == null) {
                return;
            }
            props.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean saveConfiguration() {
        Preferences prefs = NbPreferences.forModule(JasperServerManager.class);
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (int i = 0; i < this.getJServers().size(); ++i) {
            JServer server = (JServer)this.getJServers().get(i);
            prefs.put("server." + i + ".name", server.getName());
            prefs.put("server." + i + ".url", server.getUrl());
            prefs.put("server." + i + ".username", server.getUsername());
            if (this.getBrandingProperties().getProperty("irplugin.encrypt.passwords", "true").equals("true")) {
                Encrypter enc = new Encrypter(this.getBrandingProperties().getProperty("irplugin.encrypt.passwords.key", "54fj245vn3vfdsmce4mg0jvs"));
                prefs.put("server." + i + ".password.enc", enc.encrypt(server.getPassword()));
                continue;
            }
            prefs.put("server." + i + ".password", server.getPassword());
        }
        return true;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(JasperServerManager.class);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List getJServers() {
        return this.jServers;
    }

    public void setJServers(List jServers) {
        this.jServers = jServers;
    }

    public static String createTmpFileName(String filePrefix, String fileExtension) {
        filePrefix = filePrefix == null ? "" : filePrefix + "_";
        if (fileExtension != null && !fileExtension.startsWith(".")) {
            fileExtension = "." + fileExtension;
        }
        if (fileExtension == null) {
            fileExtension = ".tmp";
        }
        String tmpDirectory = System.getProperty("java.io.tmpdir");
        File tmpDirectoryFile = new File(tmpDirectory = tmpDirectory + File.separator + "jstmp");
        if (!tmpDirectoryFile.exists()) {
            tmpDirectoryFile.mkdirs();
        }
        return tmpDirectoryFile + File.separator + filePrefix + new Date().getTime() + fileExtension;
    }

    public Properties getBrandingProperties() {
        return this.brandingProperties;
    }

    public void setBrandingProperties(Properties brandingProperties) {
        this.brandingProperties = brandingProperties;
    }

    public static boolean isValidUrl(String url) {
        String strRegex = "((([0-9]{1,3}\\.){3})[0-9]{1,3})|(([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.?)++(:[0-9]{1,4})?";
        return url.matches(strRegex);
    }

    public static String getFormattedString(String cID, String defaultValue, Object[] args) {
        String pattern = JasperServerManager.getString(cID, defaultValue);
        MessageFormat mf = new MessageFormat(pattern, Locale.getDefault());
        return mf.format(args);
    }

    public static String getString(String cID, String defaultValue) {
        try {
            String newKey;
            String s = NbBundle.getMessage(JasperServerManager.class, (String)cID);
            if (s != null && s.startsWith("${") && s.endsWith("}") && (newKey = s.substring(2, s.length() - 1)).length() > 0) {
                return JasperServerManager.getString(newKey, defaultValue);
            }
            return s;
        }
        catch (MissingResourceException ex) {
            System.out.println("JS Explorer: Can't find the translation for key = " + cID + ": using default (" + defaultValue + ")");
        }
        catch (Exception ex) {
            System.out.println("JS Explorer: Exception loading cID = " + cID + ": " + ex.getMessage());
        }
        return defaultValue;
    }

    public List getSupportedQueryLanguages() {
        Iterator<Object> iter = this.getBrandingProperties().keySet().iterator();
        ArrayList<Object> list = new ArrayList<Object>();
        while (iter.hasNext()) {
            String key = "" + iter.next();
            if (!key.startsWith("query.language.") || key.endsWith(".enabled")) continue;
            String language = key.substring(15);
            if (!this.getBrandingProperties().getProperty(key + ".enabled", "true").equals("true")) continue;
            list.add(new Tag((Object)language, this.getBrandingProperties().getProperty(key)));
        }
        Object[] tobeordered = list.toArray();
        Arrays.sort(tobeordered, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tag)o1).getName().compareTo(((Tag)o2).getName());
            }

            public boolean equals(Object obj) {
                return obj != null && this.equals(obj);
            }
        });
        list.clear();
        for (int i = 0; i < tobeordered.length; ++i) {
            list.add(tobeordered[i]);
        }
        return list;
    }

    public HashMap<String, RepositoryReportUnit> getJrxmlReportUnitMap() {
        return this.jrxmlReportUnitMap;
    }

    public void setJrxmlReportUnitMap(HashMap<String, RepositoryReportUnit> jrxmlReportUnitMap) {
        this.jrxmlReportUnitMap = jrxmlReportUnitMap;
    }

    public HashMap<String, JSDataProvider> getDataProvidersMap() {
        return this.dataProvidersMap;
    }

    public void setDataProvidersMap(HashMap<String, JSDataProvider> dataProvidersMap) {
        this.dataProvidersMap = dataProvidersMap;
    }

    public void fireResourceReplacing_resourceWillBeUpdated(RepositoryFile repositoryFile, RepositoryReportUnit reportUnit, File file) throws Exception {
        for (FileResourceUpdatingListener listener : this.resourceReplacingListeners) {
            listener.resourceWillBeUpdated(repositoryFile, reportUnit, file);
        }
    }

    public void fireResourceReplacing_resourceUpdated(RepositoryFile repositoryFile, RepositoryReportUnit reportUnit, File file) throws Exception {
        for (FileResourceUpdatingListener listener : this.resourceReplacingListeners) {
            listener.resourceUpdated(repositoryFile, reportUnit, file);
        }
    }

    public static List<Action> getContributedMenuActionsFor(ResourceDescriptor rd) {
        ArrayList<Action> actions = new ArrayList<Action>();
        FileObject contributorsFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("ireport/server/menucontributors");
        if (contributorsFileObject == null) {
            return actions;
        }
        DataFolder contributorsDataFolder = DataFolder.findFolder((FileObject)contributorsFileObject);
        if (contributorsDataFolder == null) {
            return actions;
        }
        ArrayList list = new ArrayList();
        Collection resourceMenuContributorsInstances = Lookups.forPath((String)"ireport/server/menucontributors").lookupAll(ResourceMenuContributor.class);
        for (ResourceMenuContributor resourceMenuContributor : resourceMenuContributorsInstances) {
            List<Action> tActions = resourceMenuContributor.contributeMenuFor(rd);
            if (tActions == null) continue;
            actions.addAll(tActions);
        }
        return actions;
    }

    public static ResourceHandler getResourceHandler(ResourceDescriptor rd) {
        Object handler = null;
        FileObject contributorsFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("ireport/server/resourcehandlers");
        if (contributorsFileObject == null) {
            return null;
        }
        DataFolder contributorsDataFolder = DataFolder.findFolder((FileObject)contributorsFileObject);
        if (contributorsDataFolder == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        Collection resourceHanlders = Lookups.forPath((String)"ireport/server/resourcehandlers").lookupAll(ResourceHandler.class);
        for (ResourceHandler resourceHanlder : resourceHanlders) {
            if (!resourceHanlder.supportsResourceType(rd)) continue;
            return resourceHanlder;
        }
        return null;
    }
}

