/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.hadoop.hive.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.hadoop.hive.connection.HiveConnection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class HiveConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private JTextField urlField;
    private Logger logger = Logger.getLogger(HiveConnectionEditor.class);

    public HiveConnectionEditor() {
        this.initComponents();
    }

    private void initComponents() {
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        this.addLabel(propertiesPanel, "hiveURL", 0, 0, 0.0, 1.0);
        this.urlField = new JTextField("jdbc:hive://HOST:10000/default");
        this.addComponent(propertiesPanel, this.urlField, 1, 0, 0.95, 1.0, 20, 2);
        this.addComponent(propertiesPanel, Box.createHorizontalBox(), 2, 0, 0.05, 1.0, 20, 2);
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.gridx = 0;
        contraints.gridy = 0;
        contraints.fill = 2;
        contraints.anchor = 17;
        this.setLayout(new GridBagLayout());
        this.add((Component)propertiesPanel, contraints);
        contraints = new GridBagConstraints();
        contraints.gridx = 0;
        contraints.gridy = 1;
        contraints.fill = 0;
        contraints.anchor = 17;
        contraints.weightx = 1.0;
        contraints.weighty = 1.0;
        JPanel panel = new JPanel();
        this.add((Component)panel, contraints);
    }

    private void addLabel(JPanel panel, String fieldName, int gridx, int gridy, double weightx, double weighty) {
        JLabel urlLabel = new JLabel(NbBundle.getMessage(HiveConnection.class, (String)fieldName));
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.gridx = gridx;
        contraints.gridy = gridy;
        contraints.fill = 0;
        contraints.insets = new Insets(5, 5, 2, 5);
        contraints.anchor = 17;
        contraints.weightx = weightx;
        contraints.weighty = weighty;
        panel.add((Component)urlLabel, contraints);
    }

    private void addComponent(JPanel panel, JComponent component, int gridx, int gridy, double weightx, double weighty, int ipadx, int fill) {
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.gridx = gridx;
        contraints.gridy = gridy;
        contraints.fill = fill;
        contraints.anchor = 17;
        contraints.insets = new Insets(2, 5, 5, 5);
        contraints.ipadx = ipadx;
        contraints.weightx = weightx;
        contraints.weighty = weighty;
        panel.add((Component)component, contraints);
    }

    public IReportConnection getIReportConnection() {
        HiveConnection connection = new HiveConnection();
        connection.setUrl(this.urlField.getText().trim());
        return connection;
    }

    public void setIReportConnection(IReportConnection connection) {
        if (connection instanceof HiveConnection) {
            HiveConnection hiveConnection = (HiveConnection)connection;
            this.urlField.setText(hiveConnection.getUrl());
        }
    }
}

