/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramQuery;
import nickyb.sqleonardo.querybuilder.DiagramRelation;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.dnd.EntityDropTargetListener;
import nickyb.sqleonardo.querybuilder.syntax.DerivedTable;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class ViewDiagram
extends BorderLayoutPanel {
    static Color BGCOLOR_DEFAULT = Color.white;
    static Color BGCOLOR_JOINED = new Color(225, 235, 224);
    static Color BGCOLOR_START_JOIN = new Color(255, 230, 230);
    private static int FRAME_OFFSET = 50;
    private Point nextGoodPoint = new Point(10, 10);
    private Point maxCorner = new Point(0, 0);
    private DiagramRelation highlight;
    private DiagramRelation temporany;
    private InternalDiagramManager manager;
    private JScrollPane scroll;
    private JDesktopPane desktop;
    private QueryBuilder builder;
    private JPopupMenu jPopupMenuDiagram = null;
    private boolean draggable = true;

    ViewDiagram(QueryBuilder builder) {
        this.setBuilder(builder);
        this.desktop = new JDesktopPane();
        this.manager = new InternalDiagramManager();
        this.desktop.setDesktopManager(this.manager);
        this.desktop.setDragMode(1);
        this.desktop.setDropTarget(new DropTarget(this, new EntityDropTargetListener(this)));
        this.desktop.setBackground(UIManager.getColor("panel.background"));
        this.scroll = new JScrollPane(this.desktop);
        this.scroll.getVerticalScrollBar().setUnitIncrement(25);
        this.setComponentCenter(this.scroll);
        this.jPopupMenuDiagram = new JPopupMenu();
        this.jPopupMenuDiagram.add(builder.getActionMap().get("entities-arrange"));
        this.jPopupMenuDiagram.add(builder.getActionMap().get("entities-pack"));
        this.jPopupMenuDiagram.add(builder.getActionMap().get("entities-remove"));
        this.jPopupMenuDiagram.addSeparator();
        this.jPopupMenuDiagram.add(builder.getActionMap().get("diagram-save-as-image"));
        this.jPopupMenuDiagram.addSeparator();
        this.jPopupMenuDiagram.add(builder.getActionMap().get("copy-syntax"));
        this.desktop.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ViewDiagram.this.jPopupMenuDiagram.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }

    public Component add(Component c) {
        if (c instanceof DiagramAbstractEntity) {
            ((DiagramAbstractEntity)c).doFlush();
            return this.desktop.add(c);
        }
        if (c instanceof DiagramRelation) {
            this.desktop.add(((DiagramRelation)c).anchor);
            return this.desktop.add(c);
        }
        return super.add(c);
    }

    public void remove(Component c) {
        if (c instanceof DiagramAbstractEntity) {
            DiagramAbstractEntity entity = (DiagramAbstractEntity)c;
            this.desktop.remove(c);
            if (this.temporany != null && entity == this.temporany.primaryEntity) {
                this.temporany = null;
            }
        } else if (c instanceof DiagramRelation) {
            this.desktop.remove(((DiagramRelation)c).anchor);
            this.desktop.remove(c);
        } else {
            super.remove(c);
        }
    }

    void addEntity(DiagramAbstractEntity item) {
        if ((double)(item.getWidth() + this.nextGoodPoint.x) > this.getBounds().getWidth()) {
            this.nextGoodPoint.setLocation(10, this.maxCorner.y + FRAME_OFFSET);
        }
        this.addEntity(item, this.nextGoodPoint);
    }

    void addEntity(DiagramAbstractEntity item, Point location) {
        item.setLocation(location);
        item.setVisible(true);
        this.manager.openFrame(item);
    }

    DiagramQuery getEntity(DerivedTable subquery) {
        DiagramAbstractEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            if (!(entities[i] instanceof DiagramQuery)) continue;
            DiagramQuery entity = (DiagramQuery)entities[i];
            if (!subquery.getAlias().equalsIgnoreCase(entity.getQueryToken().getReference())) continue;
            return entity;
        }
        return null;
    }

    public DiagramEntity getEntity(QueryTokens.Table table) {
        return this.getEntity(table, true);
    }

    DiagramEntity getEntity(String schema, String table) {
        QueryTokens.Table token = new QueryTokens.Table(schema, table);
        return this.getEntity(token, false);
    }

    private DiagramEntity getEntity(QueryTokens.Table token, boolean ref) {
        DiagramAbstractEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            if (!(entities[i] instanceof DiagramEntity)) continue;
            DiagramEntity entity = (DiagramEntity)entities[i];
            if (!(ref ? token.getReference().equalsIgnoreCase(entity.getQueryToken().getReference()) : token.getIdentifier().equalsIgnoreCase(entity.getQueryToken().getIdentifier()))) continue;
            return entity;
        }
        return null;
    }

    DiagramAbstractEntity[] getEntities() {
        JInternalFrame[] internalframes = this.desktop.getAllFramesInLayer(JDesktopPane.PALETTE_LAYER);
        DiagramAbstractEntity[] entities = new DiagramAbstractEntity[internalframes.length];
        System.arraycopy(internalframes, 0, entities, 0, internalframes.length);
        return entities;
    }

    int getEntityCount() {
        return this.desktop.getAllFramesInLayer(JDesktopPane.PALETTE_LAYER).length;
    }

    void addRelation(DiagramRelation relation) {
        relation.onCreate(this.getBuilder());
        relation.doResize();
        int idx = this.getRelationCount();
        this.desktop.add((Component)relation.anchor, 0);
        this.desktop.add((Component)relation, idx * 2 + 1);
    }

    DiagramRelation getRelation(QueryTokens.Join token) {
        DiagramRelation[] relations = this.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            if (!token.getPrimary().getIdentifier().equalsIgnoreCase(relations[i].querytoken.getPrimary().getIdentifier()) || !token.getForeign().getIdentifier().equalsIgnoreCase(relations[i].querytoken.getForeign().getIdentifier())) continue;
            return relations[i];
        }
        return null;
    }

    DiagramRelation[] getRelations() {
        DiagramRelation[] relations = new DiagramRelation[this.getRelationCount()];
        if (relations.length > 0) {
            int j = 0;
            int count = this.desktop.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component next = this.desktop.getComponent(i);
                if (!(next instanceof DiagramRelation)) continue;
                relations[j++] = (DiagramRelation)next;
            }
        }
        return relations;
    }

    int getRelationCount() {
        return (this.desktop.getComponentCount() - this.getEntityCount()) / 2;
    }

    void removeRelation(DiagramRelation relation) {
        this.desktop.remove(relation.anchor);
        this.desktop.remove(relation);
        this.desktop.repaint();
        relation.onDestroy(this.getBuilder());
    }

    void removeAllRelation(DiagramAbstractEntity table) {
        DiagramRelation[] relations = this.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            if (relations[i].primaryEntity != table && relations[i].foreignEntity != table) continue;
            this.removeRelation(relations[i]);
        }
    }

    void setHighlight(DiagramRelation relation) {
        if (this.highlight != null) {
            if (relation.equals(this.highlight)) {
                return;
            }
            this.highlight.setHighlight(false);
        }
        this.highlight = relation;
        this.highlight.setHighlight(true);
        this.desktop.setPosition(relation.anchor, 0);
        this.desktop.setPosition(relation, this.getRelationCount());
    }

    boolean isDragAndDropEnabled() {
        return this.draggable;
    }

    void setDragAndDropEnabled(boolean b) {
        this.draggable = b;
        DiagramAbstractEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            entities[i].setDragAndDropEnabled(b);
        }
        if (this.temporany != null) {
            this.temporany.primaryField.setBackground(this.temporany.primaryField.isJoined() ? BGCOLOR_JOINED : BGCOLOR_DEFAULT);
        }
        this.temporany = null;
    }

    public void join(DiagramAbstractEntity eP, DiagramField fP, DiagramAbstractEntity eF, DiagramField fF) {
        this.temporany = null;
        this.join(eP, fP);
        this.join(eF, fF);
    }

    void join(DiagramAbstractEntity entity, DiagramField field) {
        if (this.temporany == null) {
            this.temporany = new DiagramRelation(this);
            this.temporany.primaryEntity = entity;
            this.temporany.primaryField = field;
            if (!this.getBuilder().isDragAndDropEnabled()) {
                this.temporany.primaryField.setBackground(BGCOLOR_START_JOIN);
            }
        } else if (entity == this.temporany.primaryEntity) {
            this.temporany.primaryField.setBackground(this.temporany.primaryField.isJoined() ? BGCOLOR_JOINED : BGCOLOR_DEFAULT);
            if (field != this.temporany.primaryField) {
                this.temporany.primaryField = field;
                if (!this.getBuilder().isDragAndDropEnabled()) {
                    this.temporany.primaryField.setBackground(BGCOLOR_START_JOIN);
                }
            } else {
                this.temporany = null;
            }
        } else {
            this.temporany.foreignEntity = entity;
            this.temporany.foreignField = field;
            QueryTokens.Join join = new QueryTokens.Join(this.temporany.primaryField.querytoken, "=", this.temporany.foreignField.querytoken);
            if (this.getRelation(join) == null) {
                this.temporany.primaryField.joined();
                this.temporany.primaryField.setBackground(BGCOLOR_JOINED);
                this.temporany.foreignField.joined();
                this.temporany.foreignField.setBackground(BGCOLOR_JOINED);
                this.addRelation(this.temporany);
                this.temporany = null;
            } else {
                JOptionPane.showMessageDialog(this, I18n.getFormattedString("querybuilder.message.joinAlreadyExists", "Join already exists: {0}", new Object[]{"" + join}), I18n.getString("querybuilder.message.addJoin", "add join"), 2);
                this.temporany.foreignEntity = null;
                this.temporany.foreignField = null;
            }
        }
    }

    void saveAsImage(String filename) throws ImageFormatException, IOException {
        BufferedImage image = null;
        Image capture = this.desktop.createImage(this.desktop.getWidth(), this.desktop.getHeight());
        FileOutputStream out = new FileOutputStream(filename);
        Graphics captureG = capture.getGraphics();
        this.desktop.paint(captureG);
        image = (BufferedImage)capture;
        if (image != null) {
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(1.0f, true);
            encoder.encode(image, param);
            out.flush();
        }
        out.close();
    }

    void doArrangeEntities() {
        Dimension full = new Dimension(10, 10);
        Dimension view = this.scroll.getVisibleRect().getSize();
        DiagramAbstractEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            Point next = new Point();
            next.x = full.width;
            next.y = full.height;
            if (next.x + entities[i].getWidth() > view.width) {
                next.x = 10;
                next.y = full.height + entities[i].getHeight() + FRAME_OFFSET;
            }
            entities[i].setLocation(next);
            full.width = next.x + entities[i].getWidth() + FRAME_OFFSET;
            full.height = next.y;
        }
        this.doResize();
    }

    void doResize() {
        this.doResizeDesktop();
        this.doResizeRelations();
    }

    void doResizeDesktop() {
        Dimension dimDesk;
        this.maxCorner.setLocation(0, 0);
        this.nextGoodPoint.setLocation(10, 10);
        DiagramAbstractEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            Point corner = new Point(entities[i].getX() + entities[i].getWidth(), entities[i].getY() + entities[i].getHeight());
            if (corner.x > this.maxCorner.x) {
                this.maxCorner.x = corner.x;
            }
            if (corner.y > this.maxCorner.y) {
                this.maxCorner.y = corner.y;
            }
            if (entities[i].getY() < this.nextGoodPoint.y) continue;
            this.nextGoodPoint.x = corner.x + FRAME_OFFSET;
            this.nextGoodPoint.y = entities[i].getY();
        }
        Dimension dimView = this.scroll.getVisibleRect().getSize();
        if (this.scroll.getBorder() != null) {
            Insets scrollInsets = this.scroll.getBorder().getBorderInsets(this.scroll);
            dimView.setSize(dimView.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, dimView.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
        }
        if ((dimDesk = new Dimension(this.maxCorner.x, this.maxCorner.y)).getWidth() <= dimView.getWidth()) {
            dimDesk.width = (int)dimView.getWidth() - 20;
        }
        if (dimDesk.getHeight() <= dimView.getHeight()) {
            dimDesk.height = (int)dimView.getHeight() - 20;
        }
        this.desktop.setMinimumSize(dimDesk);
        this.desktop.setMaximumSize(dimDesk);
        this.desktop.setPreferredSize(dimDesk);
        this.scroll.validate();
    }

    void doResizeRelations() {
        DiagramRelation[] relations = this.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            relations[i].doResize();
        }
    }

    void onModelChanged() {
        this.highlight = null;
        this.temporany = null;
        this.nextGoodPoint = new Point(10, 10);
        this.maxCorner = new Point(0, 0);
        this.desktop.removeAll();
    }

    public QueryBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(QueryBuilder builder) {
        this.builder = builder;
    }

    private class InternalDiagramManager
    extends DefaultDesktopManager {
        private InternalDiagramManager() {
        }

        public void closeFrame(JInternalFrame f) {
            DiagramAbstractEntity entity = (DiagramAbstractEntity)f;
            entity.onDestroy();
            super.closeFrame(f);
            if (ViewDiagram.this.temporany != null && entity == ((ViewDiagram)ViewDiagram.this).temporany.primaryEntity) {
                ViewDiagram.this.temporany = null;
            }
            ViewDiagram.this.doResizeDesktop();
        }

        public void openFrame(JInternalFrame f) {
            ViewDiagram.this.desktop.add(f);
            ViewDiagram.this.doResizeDesktop();
            DiagramAbstractEntity entity = (DiagramAbstractEntity)f;
            entity.onCreate();
        }

        public void endDraggingFrame(JComponent f) {
            super.endDraggingFrame(f);
            ViewDiagram.this.doResize();
        }
    }
}

