/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.BaseMask;
import nickyb.sqleonardo.querybuilder.DiagramRelation;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.ViewDiagram;

public class MaskJoin
extends BaseMask {
    private JCheckBox allLeft;
    private JCheckBox allRight;
    private JComboBox operator;
    private DiagramRelation relation;

    public MaskJoin(DiagramRelation relation, QueryBuilder builder) {
        super("join.edit", builder);
        this.relation = relation;
        JLabel primary = new JLabel(relation.primaryField.querytoken.getIdentifier(), 0);
        JLabel foreign = new JLabel(relation.foreignField.querytoken.getIdentifier(), 0);
        CompoundBorder border = new CompoundBorder(LineBorder.createBlackLineBorder(), new EmptyBorder(3, 4, 3, 4));
        primary.setBorder(border);
        primary.setOpaque(true);
        primary.setBackground(ViewDiagram.BGCOLOR_START_JOIN);
        foreign.setBorder(border);
        foreign.setOpaque(true);
        foreign.setBackground(ViewDiagram.BGCOLOR_JOINED);
        this.operator = new JComboBox<String>(new String[]{"=", "<", ">", "<=", ">=", "<>"});
        this.operator.setSelectedItem(relation.querytoken.getCondition().getOperator());
        GridBagLayout gbl = new GridBagLayout();
        JPanel pane = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 3, 0);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(primary, gbc);
        pane.add(primary);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbl.setConstraints(this.operator, gbc);
        pane.add(this.operator);
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(foreign, gbc);
        pane.add(foreign);
        gbc.insets = new Insets(8, 0, 0, 0);
        this.allLeft = new JCheckBox(I18n.getFormattedString("querybuilder.checkbox.allRowsFrom", "all rows from {0}", new Object[]{"" + relation.primaryEntity.getHeaderMenu().getText()}));
        this.allLeft.setSelected(relation.querytoken.getType() == 1 || relation.querytoken.getType() == 3);
        pane.add(this.allLeft);
        gbl.setConstraints(this.allLeft, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.allRight = new JCheckBox(I18n.getFormattedString("querybuilder.checkbox.allRowsFrom", "all rows from {0}", new Object[]{"" + relation.foreignEntity.getHeaderMenu().getText()}));
        this.allRight.setSelected(relation.querytoken.getType() == 2 || relation.querytoken.getType() == 3);
        pane.add(this.allRight);
        gbl.setConstraints(this.allRight, gbc);
        this.add(pane);
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 170);
    }

    protected void onShow() {
    }

    protected boolean onConfirm() {
        int jointype = 0;
        jointype += this.allLeft.isSelected() ? 1 : 0;
        this.relation.setValues(jointype += this.allRight.isSelected() ? 2 : 0, this.operator.getSelectedItem().toString());
        return true;
    }
}

