/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.util.Classpath;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.define.ColumnsChooser;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogExport;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.SideSearchCriteria;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;
import nickyb.sqleonardo.environment.ctrl.explorer.UoLinks;
import nickyb.sqleonardo.environment.mdi.ClientMetadataExplorer;

public class MetadataExplorer
extends BorderLayoutPanel
implements ChangeListener,
TreeSelectionListener {
    public static final String ALL_TABLE_TYPES_LABEL = I18n.getString("querybuilder.objetctype.all", "All");
    private CardLayout cv;
    private JTabbedPane tp;
    private SideNavigator navigator;
    private SideSearchCriteria search;

    public MetadataExplorer() {
        super(2, 2);
        this.getActionMap().put("choose-columns", new ActionChooseColumns());
        this.getActionMap().put("list-copy", new ActionCopyList());
        this.getActionMap().put("list-export", new ActionExportList());
        this.getActionMap().put("list-refresh", new ActionRefreshList());
        this.initComponents();
        this.loadNavigator();
    }

    private void initComponents() {
        this.navigator = new SideNavigator();
        this.search = new SideSearchCriteria();
        JSplitPane split = new JSplitPane();
        split.setDividerLocation(250);
        split.setOneTouchExpandable(true);
        this.setComponentCenter(split);
        Container container = new Container();
        this.cv = new CardLayout();
        container.setLayout(this.cv);
        container.add("first", this.navigator.getRightView());
        container.add("last", this.search.getRightView());
        split.setRightComponent(container);
        this.tp = new JTabbedPane(3);
        this.tp.addTab("browse", this.navigator);
        this.tp.addTab("search", this.search);
        this.tp.addChangeListener(this);
        split.setLeftComponent(this.tp);
    }

    public SideNavigator getNavigator() {
        return this.navigator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNavigator() {
        if (Application.session.canMount("$JDBC")) {
            Application.session.mount("$JDBC");
            Application.session.home();
            Enumeration eDv = Application.session.jumps();
            while (eDv.hasMoreElements()) {
                UoDriver uoDv = new UoDriver();
                uoDv.name = eDv.nextElement().toString();
                Application.session.jump(uoDv.name);
                Object[] dvInfo = (Object[])Application.session.jump().get(0);
                uoDv.library = dvInfo[0] == null ? "" : dvInfo[0].toString();
                uoDv.classname = dvInfo[1] == null ? "" : dvInfo[1].toString();
                uoDv.example = dvInfo[2] == null ? "" : dvInfo[2].toString();
                try {
                    ConnectionAssistant.declare(uoDv.library, uoDv.classname, !Classpath.isRuntime(uoDv.library));
                }
                catch (Exception e) {
                    uoDv.message = e.toString();
                }
                finally {
                    this.navigator.add(uoDv);
                }
                Enumeration eDs = Application.session.jumps();
                while (eDs.hasMoreElements()) {
                    UoDatasource uoDs = new UoDatasource(uoDv);
                    uoDs.name = eDs.nextElement().toString();
                    this.navigator.add(uoDs);
                    Application.session.home();
                    Application.session.jump(new String[]{uoDv.name, uoDs.name});
                    Object[] dsInfo = (Object[])Application.session.jump().get(0);
                    uoDs.url = dsInfo[0] == null ? "" : dsInfo[0].toString();
                    String string = uoDs.uid = dsInfo[1] == null ? "" : dsInfo[1].toString();
                    uoDs.pwd = dsInfo.length >= 3 && (uoDs.remember = dsInfo[2] != null) ? dsInfo[2].toString() : "";
                    if (dsInfo.length >= 4) {
                        uoDs.auto_connect = (Boolean)dsInfo[3];
                    }
                    if (dsInfo.length == 5) {
                        uoDs.schema = dsInfo[4] == null ? null : dsInfo[4].toString();
                    }
                    UoLinks uoLk = (UoLinks)this.navigator.getSelectionNode().getLastLeaf().getUserObject();
                    Enumeration eLk = Application.session.jumps();
                    while (eLk.hasMoreElements()) {
                        String group = eLk.nextElement().toString();
                        Application.session.home();
                        Application.session.jump(new String[]{uoDv.name, uoDs.name, group});
                        for (int i = 0; i < Application.session.jump().size(); ++i) {
                            Object[] link = (Object[])Application.session.jump().get(i);
                            uoLk.add(group, link[0] == null ? null : link[0].toString(), link[1].toString(), link[2].toString());
                        }
                    }
                }
                Application.session.home();
            }
        } else {
            UoDriver.loadDefaults(this);
        }
        this.navigator.clearSelection();
        this.navigator.sort(this.navigator.getRootNode());
        this.navigator.addTreeSelectionListener(this);
    }

    public void unloadNavigator() {
        Application.session.umount("$JDBC");
        Application.session.mount("$JDBC");
        DefaultMutableTreeNode root = this.navigator.getRootNode();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            UoDriver uoDv = (UoDriver)node.getUserObject();
            Application.session.jump(uoDv.name).add(new String[]{uoDv.library, uoDv.classname, uoDv.example});
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                UoDatasource uoDs = (UoDatasource)child.getUserObject();
                if (uoDs.isConnected()) {
                    try {
                        uoDs.disconnect();
                    }
                    catch (Exception e) {
                        Application.println(e, false);
                    }
                }
                Application.session.home();
                Application.session.jump(new String[]{uoDv.name, uoDs.name});
                Application.session.jump().add(new Object[]{uoDs.url, uoDs.uid, uoDs.remember ? uoDs.pwd : null, new Boolean(uoDs.auto_connect), uoDs.schema});
                UoLinks uoLk = (UoLinks)child.getLastLeaf().getUserObject();
                Iterator iG = uoLk.getGroups().iterator();
                while (iG.hasNext()) {
                    String group = iG.next().toString();
                    Application.session.home();
                    Application.session.jump(new String[]{uoDv.name, uoDs.name, group});
                    Iterator iK = uoLk.getLinks(group).iterator();
                    while (iK.hasNext()) {
                        Application.session.jump().add(iK.next());
                    }
                }
            }
            Application.session.home();
        }
    }

    public void setPreferences() {
        this.navigator.setPreferences();
        this.search.setPreferences();
    }

    private void onSomethingChanged() {
        this.getActionMap().get("choose-columns").setEnabled(false);
        this.getActionMap().get("list-refresh").setEnabled(false);
        this.getActionMap().get("list-copy").setEnabled(false);
        this.getActionMap().get("list-export").setEnabled(false);
        if (this.tp.getSelectedIndex() == 1) {
            this.getActionMap().get("list-copy").setEnabled(true);
            this.getActionMap().get("list-export").setEnabled(true);
        } else if (!this.navigator.isSelectionEmpty() && !this.navigator.getSelectionNode().getAllowsChildren()) {
            this.getActionMap().get("list-copy").setEnabled(true);
            this.getActionMap().get("list-export").setEnabled(true);
            this.getActionMap().get("list-refresh").setEnabled(!(this.navigator.getSelectionNode().getUserObject() instanceof UoLinks));
            this.getActionMap().get("choose-columns").setEnabled(!(this.navigator.getSelectionNode().getUserObject() instanceof UoLinks));
        }
        ClientMetadataExplorer cme = (ClientMetadataExplorer)Application.window.getClient("metadata explorer");
        cme.onSomethingChanged(this.tp.getSelectedIndex() == 0);
    }

    private void showFirst() {
        this.cv.first((Container)((JSplitPane)this.getComponent(0)).getRightComponent());
    }

    private void showLast() {
        this.cv.last((Container)((JSplitPane)this.getComponent(0)).getRightComponent());
    }

    public void stateChanged(ChangeEvent ce) {
        if (this.tp.getSelectedIndex() == 0) {
            this.showFirst();
        } else {
            this.showLast();
        }
        this.onSomethingChanged();
    }

    public void valueChanged(TreeSelectionEvent tse) {
        this.onSomethingChanged();
    }

    private class ActionRefreshList
    extends AbstractAction {
        private ActionRefreshList() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            this.putValue("Name", "refresh");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            TreePath path = MetadataExplorer.this.navigator.getSelectionPath();
            MetadataExplorer.this.navigator.clearSelection();
            MetadataExplorer.this.navigator.setSelectionPath(path);
        }
    }

    private class ActionExportList
    extends AbstractAction {
        private ActionExportList() {
            this.putValue("Name", "export list...");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            ListView lv = null;
            if (MetadataExplorer.this.tp.getSelectedIndex() == 0) {
                int last = MetadataExplorer.this.navigator.getRightView().getComponentCount() - 1;
                lv = (ListView)MetadataExplorer.this.navigator.getRightView().getComponent(last);
            } else {
                lv = (ListView)MetadataExplorer.this.search.getRightView();
            }
            new DialogExport(lv).setVisible(true);
        }
    }

    private class ActionCopyList
    extends AbstractAction {
        private ActionCopyList() {
            this.putValue("Name", "copy list");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            if (MetadataExplorer.this.tp.getSelectedIndex() == 0) {
                for (int i = 0; i < MetadataExplorer.this.navigator.getRightView().getComponentCount(); ++i) {
                    Component c = MetadataExplorer.this.navigator.getRightView().getComponent(i);
                    if (!c.isShowing() || !(c instanceof ListView)) continue;
                    ((ListView)c).copyAllRows();
                }
            } else {
                ((ListView)MetadataExplorer.this.search.getRightView()).copyAllRows();
            }
        }
    }

    private class ActionChooseColumns
    extends AbstractAction {
        private ActionChooseColumns() {
            this.putValue("Name", "choose columns...");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            String dvname = MetadataExplorer.this.navigator.getSelectionNode().getPath()[1].toString();
            ColumnsChooser.showDialog(dvname, "table types");
        }
    }
}

