/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

public class ConnectionHandler {
    private Connection connection;
    private Hashtable metacache;

    public ConnectionHandler(Connection connection) {
        this.connection = connection;
        this.metacache = new Hashtable();
        try {
            this.metacache.put("$maxColumnNameLength", new Integer(connection.getMetaData().getMaxColumnNameLength()));
            this.metacache.put("$identifierQuoteString", connection.getMetaData().getIdentifierQuoteString());
            this.metacache.put("$supportsSchema", new Boolean(connection.getMetaData().supportsSchemasInTableDefinitions()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadSchemas();
        this.loadTableTypes();
        this.loadConnectionInfos();
    }

    private boolean supportsSchema() {
        return (Boolean)this.metacache.get("$supportsSchema");
    }

    private void loadSchemas() {
        ArrayList<String> schemas = new ArrayList<String>();
        this.metacache.put("$schema_names", schemas);
        try {
            if (this.supportsSchema()) {
                ResultSet rs = this.connection.getMetaData().getSchemas();
                while (rs.next()) {
                    String name = rs.getString(1).trim();
                    if (schemas.contains(name)) continue;
                    schemas.add(name);
                }
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTableTypes() {
        ArrayList<String> tableTypes = new ArrayList<String>();
        this.metacache.put("$table_types", tableTypes);
        try {
            ResultSet rs = this.connection.getMetaData().getTableTypes();
            while (rs.next()) {
                String type = rs.getString(1).trim();
                if (tableTypes.contains(type)) continue;
                tableTypes.add(type);
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadConnectionInfos() {
        ArrayList<String[]> infos = new ArrayList<String[]>();
        this.metacache.put("$connection_infos", infos);
        try {
            String[] info = new String[]{"database product name", this.connection.getMetaData().getDatabaseProductName()};
            infos.add(info);
            info = new String[]{"database product version", this.connection.getMetaData().getDatabaseProductVersion()};
            infos.add(info);
            info = new String[]{"driver name", this.connection.getMetaData().getDriverName()};
            infos.add(info);
            info = new String[]{"driver version", this.connection.getMetaData().getDriverVersion()};
            infos.add(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Connection get() {
        return this.connection;
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public ArrayList getArrayList(String key) {
        return (ArrayList)this.metacache.get(key);
    }

    public Object getObject(String key) {
        return this.metacache.get(key);
    }
}

