/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.transformer.tool;

import com.jaspersoft.ireport.addons.transformer.tool.FileEntry;
import com.jaspersoft.ireport.addons.transformer.tool.TransformationFrame;
import java.io.File;
import javax.swing.table.DefaultTableModel;

public class FindThread
implements Runnable {
    private TransformationFrame massiveCompilerFrame = null;
    private boolean stop = false;
    private Thread thread = null;

    public FindThread(TransformationFrame mcf) {
        this.massiveCompilerFrame = mcf;
        this.thread = new Thread(this);
    }

    public void stop() {
        this.stop = true;
    }

    public void start() {
        this.thread.start();
    }

    public void run() {
        if (this.massiveCompilerFrame == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.massiveCompilerFrame.getFileTable().getModel();
        dtm.setRowCount(0);
        this.massiveCompilerFrame.getFileTable().updateUI();
        File path = new File(this.massiveCompilerFrame.getFindDirectory());
        if (path == null || !path.exists() || path.isFile()) {
            return;
        }
        if (!this.stop) {
            this.findFiles(path, this.massiveCompilerFrame.isSearchSubDirectory(), dtm);
        }
        this.massiveCompilerFrame.finishedFind();
    }

    private int findFiles(File path, boolean recursive, DefaultTableModel tmodel) {
        if (this.stop) {
            return 0;
        }
        int count = 0;
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (this.stop) {
                return 0;
            }
            if (files[i].isDirectory() && recursive) {
                count += this.findFiles(files[i], recursive, tmodel);
                continue;
            }
            if (!files[i].getName().toLowerCase().endsWith(".xml") && !files[i].getName().toLowerCase().endsWith(".jrxml")) continue;
            FileEntry fe = new FileEntry();
            fe.setFile(files[i]);
            fe.setStatus(1);
            tmodel.addRow(new Object[]{fe, fe, fe.decodeStatus(fe.getStatus())});
        }
        return count;
    }
}

