/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.background;

import com.jaspersoft.ireport.addons.background.BackgroundImageUtilities;
import com.jaspersoft.ireport.addons.background.BackgroundImageWidget;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportDesignerPanel;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public class ShowBackgroundImageAction
extends CallableSystemAction
implements Presenter.Menu,
Presenter.Popup,
LookupListener {
    private final Lookup lkp = Utilities.actionsGlobalContext();
    private final Lookup.Result<? extends ReportDesignerPanel> result = this.lkp.lookupResult(ReportDesignerPanel.class);
    JCheckBoxMenuItem menu = null;

    public ShowBackgroundImageAction() {
        this.result.addLookupListener((LookupListener)this);
        this.result.allItems();
    }

    public JMenuItem getMenuPresenter() {
        return this.getMenu();
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenu();
    }

    public void performAction() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
                BackgroundImageWidget w = BackgroundImageUtilities.getBackgroundImageWidget(view);
                if (w != null) {
                    w.setImageVisible(ShowBackgroundImageAction.this.getMenu().isSelected());
                }
                BackgroundImageUtilities.notifyBackgroundOptionsChange();
            }
        });
    }

    protected boolean enable() {
        this.getMenu().setSelected(false);
        this.getMenu().setEnabled(false);
        if (IReportManager.getInstance().getActiveVisualView() != null) {
            BackgroundImageWidget w = BackgroundImageUtilities.getBackgroundImageWidget(IReportManager.getInstance().getActiveVisualView());
            this.getMenu().setEnabled(w != null);
            this.getMenu().setSelected(w != null && w.isVisible());
        }
        return this.getMenu().isEnabled();
    }

    public String getName() {
        return NbBundle.getMessage(ShowBackgroundImageAction.class, (String)"action.showBackgroundImage");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected JCheckBoxMenuItem getMenu() {
        if (this.menu == null) {
            this.menu = new JCheckBoxMenuItem(this.getName());
            this.menu.addActionListener((ActionListener)((Object)this));
            this.menu.setSelected(true);
            this.menu.setEnabled(false);
        }
        return this.menu;
    }

    public void resultChanged(LookupEvent le) {
        this.enable();
    }

    protected boolean asynchronous() {
        return false;
    }
}

