/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.MoveControlPointProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public final class MoveControlPointAction
extends WidgetAction.LockedAdapter {
    private MoveControlPointProvider provider;
    private ConnectionWidget.RoutingPolicy routingPolicy;
    private ConnectionWidget movingWidget = null;
    private Point controlPointLocation;
    private int controlPointIndex;
    private Point lastLocation = null;

    public MoveControlPointAction(MoveControlPointProvider moveControlPointProvider, ConnectionWidget.RoutingPolicy routingPolicy) {
        this.provider = moveControlPointProvider;
        this.routingPolicy = routingPolicy;
    }

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1 && widget instanceof ConnectionWidget) {
            ConnectionWidget connectionWidget = (ConnectionWidget)widget;
            this.controlPointIndex = connectionWidget.getControlPointHitAt(widgetMouseEvent.getPoint());
            if (this.controlPointIndex >= 0) {
                this.movingWidget = connectionWidget;
                this.controlPointLocation = new Point(connectionWidget.getControlPoints().get(this.controlPointIndex));
                this.lastLocation = new Point(widgetMouseEvent.getPoint());
                return WidgetAction.State.createLocked(widget, this);
            }
            this.movingWidget = null;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        WidgetAction.State state = this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        this.movingWidget = null;
        return state;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.move(widget, widgetMouseEvent.getPoint())) {
            return WidgetAction.State.createLocked(widget, this);
        }
        this.movingWidget = null;
        return WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.movingWidget != widget) {
            return false;
        }
        List<Point> list = this.movingWidget.getControlPoints();
        if (this.controlPointIndex < 0 || this.controlPointIndex >= list.size()) {
            return false;
        }
        Point point2 = new Point(this.controlPointLocation);
        point2.translate(point.x - this.lastLocation.x, point.y - this.lastLocation.y);
        list = this.provider.locationSuggested(this.movingWidget, this.controlPointIndex, point2);
        if (list == null) {
            return false;
        }
        if (this.routingPolicy != null) {
            this.movingWidget.setRoutingPolicy(this.routingPolicy);
        }
        this.movingWidget.setControlPoints(list, false);
        return true;
    }
}

