/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.CommentTable;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.ModifyColumn;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ColumnNode;

public class ColumnNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = -1470704512178901918L;
    private static final Logger LOGGER = Logger.getLogger(ColumnNode.class.getName());
    private static final double JAVADB_MINOR_VERSION_SUPPORTED = 3.0;
    private static final String DELETE_ACTION_CLASS = "DeleteAction";

    public Vector getActions() {
        Vector vector = super.getActions();
        Vector vector2 = new Vector();
        Specification specification = (Specification)this.getSpecification();
        for (int i = 0; i < vector.size(); ++i) {
            if (specification.getProperties().get("DatabaseProductName").equals("Apache Derby") && !this.isSupported(specification)) {
                String string;
                if (vector.get(i) == null || (string = vector.get(i).getClass().getSimpleName()).equals(DELETE_ACTION_CLASS)) continue;
                vector2.add(vector.get(i));
                continue;
            }
            vector2.add(vector.get(i));
        }
        return vector2;
    }

    public boolean canAdd(Map map, String string) {
        if (string.equals("decdigits")) {
            int n = (Integer)this.get("datatype");
            return n == 6 || n == 7 || n == 8;
        }
        return super.canAdd(map, string);
    }

    public Object getProperty(String string) {
        Object object;
        if ((string.equals("columnsize") || string.equals("decdigits") || string.equals("ordpos") || string.equals("key_seq")) && (object = this.get(string)) instanceof String) {
            return Integer.valueOf((String)object);
        }
        if (string.equals("isnullable")) {
            object = (String)this.get(string);
            boolean bl = object == null ? false : ((String)object).toUpperCase().equals("YES");
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(string);
    }

    public void delete() throws IOException {
        try {
            String string = this.getCode();
            String string2 = (String)this.get("table");
            Specification specification = (Specification)this.getSpecification();
            RemoveColumn removeColumn = specification.createCommandRemoveColumn(string2);
            removeColumn.removeColumn((String)this.get(string));
            removeColumn.setObjectOwner((String)this.get("schema"));
            removeColumn.execute();
            this.notifyChange();
        }
        catch (Exception exception) {
            DbUtilities.reportError(ColumnNodeInfo.bundle().getString("ERR_UnableToDeleteColumn"), exception.getMessage());
        }
    }

    public TableColumn getColumnSpecification() throws DatabaseException {
        TableColumn tableColumn;
        block12: {
            tableColumn = null;
            try {
                Specification specification = (Specification)this.getSpecification();
                CreateTable createTable = specification.createCommandCreateTable("DUMMY");
                String string = this.getCode();
                if (string.equals("pcolumn")) {
                    tableColumn = createTable.createPrimaryKeyColumn(this.getName());
                } else if (string.equals("icolumn")) {
                    tableColumn = createTable.createUniqueColumn(this.getName());
                } else if (string.equals("fcolumn")) {
                    tableColumn = null;
                } else if (string.equals("column")) {
                    tableColumn = createTable.createColumn(this.getName());
                } else {
                    String string2 = MessageFormat.format(ColumnNodeInfo.bundle().getString("EXC_UnknownCode"), string);
                    throw new DatabaseException(string2);
                }
                DriverSpecification driverSpecification = this.getDriverSpecification();
                driverSpecification.getColumns((String)this.get("table"), (String)this.get(string));
                ResultSet resultSet = driverSpecification.getResultSet();
                if (resultSet == null) break block12;
                resultSet.next();
                HashMap hashMap = driverSpecification.getRow();
                try {
                    tableColumn.setColumnType(Integer.parseInt((String)hashMap.get(new Integer(5))));
                    tableColumn.setColumnSize(Integer.parseInt((String)hashMap.get(new Integer(7))));
                }
                catch (NumberFormatException numberFormatException) {
                    tableColumn.setColumnType(0);
                    tableColumn.setColumnSize(0);
                }
                tableColumn.setNullAllowed(((String)hashMap.get(new Integer(18))).toUpperCase().equals("YES"));
                tableColumn.setDefaultValue((String)hashMap.get(new Integer(13)));
                hashMap.clear();
                resultSet.close();
            }
            catch (Exception exception) {
                throw new DatabaseException(exception);
            }
        }
        return tableColumn;
    }

    public int getColumnPosition() {
        Object object = this.getProperty("ordpos");
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public void setProperty(String string, Object object) {
        try {
            if (string.equals("remarks")) {
                this.setRemarks((String)object);
            } else if (string.equals("isnullable")) {
                this.setNullAllowed((Boolean)object);
                object = ((Boolean)object).equals(Boolean.TRUE) ? "YES" : "NO";
            } else if (string.equals("columnsize")) {
                this.setColumnSize((Integer)object);
            } else if (string.equals("decdigits")) {
                this.setDecimalDigits((Integer)object);
            } else if (string.equals("coldef")) {
                this.setDefaultValue((String)object);
            } else if (string.equals("datatype")) {
                this.setDataType((Integer)object);
            }
            super.setProperty(string, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setRemarks(String string) throws DatabaseException {
        String string2 = (String)this.get("table");
        Specification specification = (Specification)this.getSpecification();
        try {
            CommentTable commentTable = specification.createCommandCommentTable(string2, string);
            commentTable.setObjectOwner((String)this.get("schema"));
            commentTable.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setColumnSize(Integer n) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setColumnSize(n);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setDecimalDigits(Integer n) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setDecimalSize(n);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setDefaultValue(String string) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setDefaultValue(string);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setNullAllowed(boolean bl) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setNullAllowed(bl);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setDataType(Integer n) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setColumnType(n);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public int compareTo(Object object) {
        if (this.equals(object)) {
            return 0;
        }
        if (!(object instanceof ColumnNodeInfo)) {
            return super.compareTo(object);
        }
        if (this.getColumnPosition() == 0) {
            return super.compareTo(object);
        }
        return this.getColumnPosition() - ((ColumnNodeInfo)object).getColumnPosition();
    }

    private boolean isSupported(Specification specification) {
        try {
            int n;
            int n2 = specification.getMetaData().getDatabaseMajorVersion();
            if (n2 < 10) {
                return false;
            }
            String string = specification.getMetaData().getDatabaseProductVersion();
            int n3 = string.indexOf(".");
            if (n3 != -1 && (double)(n = Integer.parseInt(string.substring(n3 + 1, n3 + 2))) < 3.0) {
                return false;
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.INFO, "ColumnNodeInfo.isSupported() threw SQLException", sQLException);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.log(Level.INFO, "ColumnNodeInfo.isSupported() threw NumberFormatException retrieving the version", numberFormatException);
        }
        return true;
    }
}

