/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.openide.util.Exceptions;

public class AddGroupUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignGroup group = null;
    private JRDesignDataset dataset = null;

    public AddGroupUndoableEdit(JRDesignGroup group, JRDesignDataset dataset) {
        this.group = group;
        this.dataset = dataset;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.getDataset().removeGroup((JRGroup)this.getGroup());
    }

    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.getDataset().addGroup(this.getGroup());
        }
        catch (JRException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new CannotRedoException();
        }
    }

    public String getPresentationName() {
        String groupName = "";
        if (this.getGroup() != null && this.getGroup().getName() != null) {
            groupName = this.getGroup().getName();
        }
        return "Add group " + groupName;
    }

    public JRDesignGroup getGroup() {
        return this.group;
    }

    public void setGroup(JRDesignGroup group) {
        this.group = group;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }
}

