/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.charts.ChartSelectionJDialog;
import com.jaspersoft.ireport.designer.charts.datasets.wizards.CategoryDatasetWizardAction;
import com.jaspersoft.ireport.designer.charts.datasets.wizards.PieWizardAction;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.palette.actions.CreateReportElementAction;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.JOptionPane;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;

public class CreateChartAction
extends CreateReportElementAction {
    public JRDesignElement createReportElement(JasperDesign jd) {
        JRDesignChart element = null;
        if (this.getScene() instanceof CrosstabObjectScene) {
            Runnable r = new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), "You can not use a chart inside a crosstab", "Error", 2);
                }
            };
            Mutex.EVENT.readAccess(r);
            return null;
        }
        Window pWin = Misc.getMainWindow();
        ChartSelectionJDialog dialog = null;
        dialog = pWin instanceof Dialog ? new ChartSelectionJDialog((Dialog)pWin, true) : new ChartSelectionJDialog((Frame)pWin, true);
        dialog.setJasperDesign(jd);
        dialog.setVisible(true);
        if (dialog.getDialogResult() == 0) {
            element = dialog.getChart();
            element.setWidth(200);
            element.setHeight(100);
            if (element.getDataset() instanceof JRDesignPieDataset) {
                ((PieWizardAction)SystemAction.get(PieWizardAction.class)).configureChart((JRDesignPieDataset)element.getDataset());
            } else if (element.getDataset() instanceof JRDesignCategoryDataset) {
                ((CategoryDatasetWizardAction)SystemAction.get(CategoryDatasetWizardAction.class)).configureChart((JRDesignCategoryDataset)element.getDataset(), element.getChartType());
            }
            String s = IReportManager.getPreferences().get("DefaultTheme", "");
            if (s.length() > 0 && this.getJasperDesign().getPropertiesMap().getProperty("net.sf.jasperreports.chart.theme") == null) {
                this.getJasperDesign().getPropertiesMap().setProperty("net.sf.jasperreports.chart.theme", s);
            }
        }
        return element;
    }

    public void drop(DropTargetDropEvent dtde) {
        JRDesignChart element = (JRDesignChart)this.createReportElement(this.getJasperDesign());
        if (element == null) {
            return;
        }
        this.dropFieldElementAt(this.getScene(), this.getJasperDesign(), element, dtde.getLocation());
    }

    public void dropFieldElementAt(Scene theScene, JasperDesign jasperDesign, JRDesignChart element, Point location) {
        if (theScene instanceof ReportObjectScene) {
            Point p = theScene.convertViewToScene(location);
            JRDesignBand b = ModelUtils.getBandAt(jasperDesign, p);
            int yLocation = ModelUtils.getBandLocation((JRBand)b, jasperDesign);
            Point pLocationInBand = new Point(p.x - jasperDesign.getLeftMargin(), p.y - yLocation);
            if (b != null && b.getOrigin().getBandTypeValue() == BandTypeEnum.TITLE) {
                element.setEvaluationTime(EvaluationTimeEnum.REPORT);
            }
        }
        CreateReportElementAction.dropElementAt(theScene, jasperDesign, (JRDesignElement)element, location);
    }
}

