/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.GenericInspectorTopComponent;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.jrtx.JRTXDataObject;
import com.jaspersoft.ireport.designer.jrtx.JRTXEditorSupport;
import com.jaspersoft.ireport.designer.jrtx.JRTXPreviewPanel;
import com.jaspersoft.ireport.designer.jrtx.TemplateNode;
import com.jaspersoft.ireport.designer.undo.UndoRedoManager;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JRTXVisualView
extends TopComponent
implements DocumentListener,
MultiViewDescription,
MultiViewElement,
Runnable,
ExplorerManager.Provider {
    private JRSimpleTemplate template = null;
    private AbstractNode noTemplateNode = null;
    private JComponent toolbar = null;
    private static Boolean groupVisible = null;
    private transient ExplorerManager explorerManager;
    private JRTXEditorSupport support;
    private JRTXPreviewPanel previewPanel = null;
    private boolean elementInitialized = false;
    private boolean needModelRefresh = true;
    MultiViewElementCallback callback = null;
    InstanceContent ic;
    AbstractLookup abstractLookup;
    private ProxyLookup lookup = null;
    private static JRTXVisualView instance;
    static final String ICON_PATH = "com/jaspersoft/ireport/designer/resources/jasperreports_jrtx.png";
    private static final String PREFERRED_ID = "JRTXVisualEditorTopComponent";
    private BeanTreeView treeView;
    private PropertySheetView propertySheetView;
    private TemplateNode model = null;
    boolean loading = false;
    private UndoRedoManager undoRedoManager = null;

    public JRTXVisualView(JRTXEditorSupport ed) {
        this.support = ed;
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getDisplayName() {
        return I18n.getString("view.designer");
    }

    public TemplateNode getModel() {
        return this.model;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public Image getIcon() {
        Node nd = ((JRTXDataObject)this.support.getDataObject()).getNodeDelegate();
        return nd.getIcon(1);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public MultiViewElement createElement() {
        if (!this.elementInitialized) {
            this.noTemplateNode = new AbstractNode(Children.LEAF);
            this.noTemplateNode.setDisplayName("Template not available");
            try {
                assert (EventQueue.isDispatchThread());
                this.elementInitialized = true;
                this.ic = new InstanceContent();
                this.explorerManager = new ExplorerManager();
                this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("selectedNodes".equals(evt.getPropertyName())) {
                            JRTXVisualView.this.modelChanged();
                        }
                    }
                });
                ActionMap map = this.getActionMap();
                map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
                map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
                map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
                map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
                this.abstractLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
                this.lookup = new ProxyLookup(new Lookup[]{this.abstractLookup, ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map), this.support.getDataObject().getLookup()});
                this.associateLookup((Lookup)this.lookup);
                this.removeAll();
                this.support.openDocument().addDocumentListener(this);
                this.initComponents();
                this.setName(NbBundle.getMessage(JRTXVisualView.class, (String)"CTL_JRTXVisualEditorTopComponent"));
                this.setToolTipText(NbBundle.getMessage(JRTXVisualView.class, (String)"HINT_JRTXVisualEditorTopComponent"));
                this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
                this.setPreviewPanel(new JRTXPreviewPanel(this));
                this.add(this.getPreviewPanel(), "Center");
                this.getExplorerManager().setRootContext((Node)this.noTemplateNode);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    public synchronized void setNeedModelRefresh(boolean b) {
        this.needModelRefresh = b;
    }

    public boolean isNeedModelRefresh() {
        return this.needModelRefresh;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JPanel();
        }
        return this.toolbar;
    }

    public void componentOpened() {
        this.setNeedModelRefresh(false);
        this.refreshModel();
    }

    public void componentClosed() {
        this.syncSatelliteViews(false);
    }

    public void componentShowing() {
        if (this.isNeedModelRefresh()) {
            this.refreshModel();
        } else {
            this.support.setCurrentModel(this.template);
            this.syncSatelliteViews();
        }
    }

    public JRTXEditorSupport getEditorSupport() {
        return this.support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        try {
            this.model = null;
            RequestProcessor.getDefault().post((Runnable)this);
        }
        finally {
            this.setNeedModelRefresh(false);
        }
    }

    public void modelChanged() {
        if (this.getPreviewPanel() != null) {
            this.getPreviewPanel().modelChanged();
        }
    }

    public void updateName() {
        Runnable run = new Runnable(){

            public void run() {
                MultiViewElementCallback c = JRTXVisualView.this.callback;
                if (c == null) {
                    return;
                }
                TopComponent tc = c.getTopComponent();
                if (tc == null) {
                    return;
                }
                Node nd = ((JRTXDataObject)JRTXVisualView.this.support.getDataObject()).getNodeDelegate();
                tc.setName(nd.getName());
                tc.setDisplayName(nd.getDisplayName());
                tc.setHtmlDisplayName(nd.getHtmlDisplayName());
                tc.setToolTipText(nd.getShortDescription());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo getUndoRedo() {
        return this.getUndoRedoManager();
    }

    public Lookup getLookup() {
        return super.getLookup();
    }

    public UndoRedo.Manager getUndoRedoManager() {
        if (this.undoRedoManager == null) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(300);
        }
        return this.undoRedoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.loading = true;
        try {
            this.support.setCurrentModel(null);
            Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
            this.template = (JRSimpleTemplate)JRXmlTemplateLoader.load((InputStream)this.support.getInputStream());
            if (this.template != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JRTXVisualView.this.model = new TemplateNode(JRTXVisualView.this.template, JRTXVisualView.this.support.getSpecialNodeLookup());
                        JRTXVisualView.this.getUndoRedoManager().discardAllEdits();
                        JRTXVisualView.this.explorerManager.setRootContext((Node)JRTXVisualView.this.model);
                        JRTXVisualView.this.support.setCurrentModel(JRTXVisualView.this.template);
                        try {
                            JRTXVisualView.this.explorerManager.setSelectedNodes(new Node[]{JRTXVisualView.this.model});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            this.noTemplateNode.setDisplayName("Loading error: " + ex.getMessage());
            this.getExplorerManager().setRootContext((Node)this.noTemplateNode);
            this.model = null;
            ex.printStackTrace();
        }
        finally {
            if (this.getPreviewPanel() != null) {
                this.getPreviewPanel().modelChanged();
            }
            this.syncSatelliteViews();
            this.loading = false;
        }
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
        this.updateName();
    }

    public void requestActive() {
        if (this.callback != null) {
            this.callback.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void componentActivated() {
        this.syncSatelliteViews();
        this.updateGroupVisibility();
    }

    public void componentDeactivated() {
        this.updateGroupVisibility();
    }

    public void componentHidden() {
        this.syncSatelliteViews(false);
    }

    public CloseOperationState canCloseElement() {
        if (this.getEditorSupport().isModified()) {
            return MultiViewFactory.createUnsafeCloseState((String)PREFERRED_ID, null, null);
        }
        return CloseOperationState.STATE_OK;
    }

    private void updateGroupVisibility() {
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup("ireport_jrctx");
        if (group == null) {
            return;
        }
        boolean isVisualViewSelected = false;
        for (Mode mode : wm.getModes()) {
            String id;
            MultiViewPerspective mvp;
            MultiViewHandler mvh;
            TopComponent selected = mode.getSelectedTopComponent();
            if (selected == null || (mvh = MultiViews.findMultiViewHandler((TopComponent)selected)) == null || (mvp = mvh.getSelectedPerspective()) == null || !PREFERRED_ID.equals(id = mvp.preferredID())) continue;
            isVisualViewSelected = true;
            break;
        }
        if (isVisualViewSelected && !Boolean.TRUE.equals(groupVisible)) {
            group.open();
        } else if (!isVisualViewSelected && !Boolean.FALSE.equals(groupVisible)) {
            group.close();
        }
        groupVisible = isVisualViewSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void syncSatelliteViews() {
        this.syncSatelliteViews(true);
    }

    protected void syncSatelliteViews(final boolean b) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (b) {
                    GenericInspectorTopComponent.getDefault().setCurrentVisualView(JRTXVisualView.this);
                } else {
                    GenericInspectorTopComponent.getDefault().closingVisualView(JRTXVisualView.this);
                }
            }
        });
    }

    public JRTXPreviewPanel getPreviewPanel() {
        return this.previewPanel;
    }

    public void setPreviewPanel(JRTXPreviewPanel previewPanel) {
        this.previewPanel = previewPanel;
    }
}

