/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxBorderInfo;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class DocxBorderHelper
extends BaseHelper {
    public DocxBorderHelper(Writer writer) {
        super(writer);
    }

    public void export(JRLineBox box) {
        if (box != null) {
            this.export(new DocxBorderInfo(box));
        }
    }

    public void export(JRPen pen) {
        if (pen != null) {
            this.export(new DocxBorderInfo(pen));
        }
    }

    private void export(DocxBorderInfo info) {
        if (info.hasBorder()) {
            this.write("      <w:tcBorders>\n");
            this.exportBorder(info, 0);
            this.exportBorder(info, 1);
            this.exportBorder(info, 2);
            this.exportBorder(info, 3);
            this.write("      </w:tcBorders>\n");
        }
        this.write("      <w:tcMar>\n");
        this.exportPadding(info, 0);
        this.exportPadding(info, 1);
        this.exportPadding(info, 2);
        this.exportPadding(info, 3);
        this.write("      </w:tcMar>\n");
    }

    private void exportBorder(DocxBorderInfo info, int side) {
        if (info.borderWidth[side] != null) {
            this.write("<w:" + DocxBorderInfo.BORDER[side] + " w:val=\"" + info.borderStyle[side] + "\" w:sz=\"" + info.borderWidth[side] + "\" w:space=\"0\"");
            if (info.borderColor[side] != null) {
                this.write(" w:color=\"" + JRColorUtil.getColorHexa(info.borderColor[side]) + "\"");
            }
            this.write(" />\n");
        }
    }

    private void exportPadding(DocxBorderInfo info, int side) {
        if (info.borderPadding[side] != null) {
            this.write("       <w:" + DocxBorderInfo.BORDER[side] + " w:w=\"" + info.borderPadding[side] + "\" w:type=\"dxa\" />\n");
        }
    }
}

