/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseSection;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;

public class JRBaseReport
implements JRReport,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_WHEN_NO_DATA_TYPE = "whenNoDataType";
    protected String name;
    protected String language = "java";
    protected int columnCount = 1;
    protected PrintOrderEnum printOrderValue = PrintOrderEnum.VERTICAL;
    protected RunDirectionEnum columnDirection = RunDirectionEnum.LTR;
    protected int pageWidth = 595;
    protected int pageHeight = 842;
    protected OrientationEnum orientationValue = OrientationEnum.PORTRAIT;
    protected WhenNoDataTypeEnum whenNoDataTypeValue = WhenNoDataTypeEnum.NO_PAGES;
    protected int columnWidth = 555;
    protected int columnSpacing;
    protected int leftMargin = 20;
    protected int rightMargin = 20;
    protected int topMargin = 30;
    protected int bottomMargin = 30;
    protected boolean isTitleNewPage;
    protected boolean isSummaryNewPage;
    protected boolean isSummaryWithPageHeaderAndFooter;
    protected boolean isFloatColumnFooter;
    protected boolean ignorePagination;
    protected String formatFactoryClass;
    protected Set<String> importsSet;
    protected JRReportTemplate[] templates;
    protected JRStyle defaultStyle;
    protected JRStyle[] styles;
    protected JRDataset mainDataset;
    protected JRDataset[] datasets;
    protected JRBand background;
    protected JRBand title;
    protected JRBand pageHeader;
    protected JRBand columnHeader;
    protected JRSection detailSection;
    protected JRBand columnFooter;
    protected JRBand pageFooter;
    protected JRBand lastPageFooter;
    protected JRBand summary;
    protected JRBand noData;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40600;
    private JRBand detail;
    private byte whenNoDataType;
    private byte printOrder;
    private byte orientation;

    public JRBaseReport() {
    }

    public JRBaseReport(JRReport report, JRExpressionCollector expressionCollector) {
        this(report, new JRBaseObjectFactory(expressionCollector));
    }

    public JRBaseReport(JRReport report, JRBaseObjectFactory factory) {
        this.name = report.getName();
        this.language = report.getLanguage();
        this.columnCount = report.getColumnCount();
        this.printOrderValue = report.getPrintOrderValue();
        this.columnDirection = report.getColumnDirection();
        this.pageWidth = report.getPageWidth();
        this.pageHeight = report.getPageHeight();
        this.orientationValue = report.getOrientationValue();
        this.whenNoDataTypeValue = report.getWhenNoDataTypeValue();
        this.columnWidth = report.getColumnWidth();
        this.columnSpacing = report.getColumnSpacing();
        this.leftMargin = report.getLeftMargin();
        this.rightMargin = report.getRightMargin();
        this.topMargin = report.getTopMargin();
        this.bottomMargin = report.getBottomMargin();
        this.isTitleNewPage = report.isTitleNewPage();
        this.isSummaryNewPage = report.isSummaryNewPage();
        this.isSummaryWithPageHeaderAndFooter = report.isSummaryWithPageHeaderAndFooter();
        this.isFloatColumnFooter = report.isFloatColumnFooter();
        this.ignorePagination = report.isIgnorePagination();
        this.formatFactoryClass = report.getFormatFactoryClass();
        String[] imports = report.getImports();
        if (imports != null && imports.length > 0) {
            this.importsSet = new HashSet<String>(imports.length);
            this.importsSet.addAll(Arrays.asList(imports));
        }
        factory.setDefaultStyleProvider(this);
        this.copyTemplates(report, factory);
        this.defaultStyle = factory.getStyle(report.getDefaultStyle());
        JRStyle[] jrStyles = report.getStyles();
        if (jrStyles != null && jrStyles.length > 0) {
            this.styles = new JRStyle[jrStyles.length];
            for (int i = 0; i < this.styles.length; ++i) {
                this.styles[i] = factory.getStyle(jrStyles[i]);
            }
        }
        this.mainDataset = factory.getDataset(report.getMainDataset());
        JRDataset[] datasetArray = report.getDatasets();
        if (datasetArray != null && datasetArray.length > 0) {
            this.datasets = new JRDataset[datasetArray.length];
            for (int i = 0; i < this.datasets.length; ++i) {
                this.datasets[i] = factory.getDataset(datasetArray[i]);
            }
        }
        this.background = factory.getBand(report.getBackground());
        this.title = factory.getBand(report.getTitle());
        this.pageHeader = factory.getBand(report.getPageHeader());
        this.columnHeader = factory.getBand(report.getColumnHeader());
        this.detailSection = factory.getSection(report.getDetailSection());
        this.columnFooter = factory.getBand(report.getColumnFooter());
        this.pageFooter = factory.getBand(report.getPageFooter());
        this.lastPageFooter = factory.getBand(report.getLastPageFooter());
        this.summary = factory.getBand(report.getSummary());
        this.noData = factory.getBand(report.getNoData());
    }

    protected void copyTemplates(JRReport report, JRBaseObjectFactory factory) {
        JRReportTemplate[] reportTemplates = report.getTemplates();
        if (reportTemplates == null || reportTemplates.length == 0) {
            this.templates = null;
        } else {
            this.templates = new JRReportTemplate[reportTemplates.length];
            for (int i = 0; i < reportTemplates.length; ++i) {
                this.templates[i] = factory.getReportTemplate(reportTemplates[i]);
            }
        }
    }

    public JRBaseReport(JRReport report) {
        this(report, (JRExpressionCollector)null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public PrintOrderEnum getPrintOrderValue() {
        return this.printOrderValue;
    }

    @Override
    public RunDirectionEnum getColumnDirection() {
        return this.columnDirection;
    }

    @Override
    public int getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public int getPageHeight() {
        return this.pageHeight;
    }

    @Override
    public OrientationEnum getOrientationValue() {
        return this.orientationValue;
    }

    @Override
    public WhenNoDataTypeEnum getWhenNoDataTypeValue() {
        return this.whenNoDataTypeValue;
    }

    @Override
    public void setWhenNoDataType(WhenNoDataTypeEnum whenNoDataTypeValue) {
        WhenNoDataTypeEnum old = whenNoDataTypeValue;
        this.whenNoDataTypeValue = whenNoDataTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_TYPE, old, whenNoDataTypeValue);
    }

    @Override
    public int getColumnWidth() {
        return this.columnWidth;
    }

    @Override
    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    @Override
    public int getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public int getRightMargin() {
        return this.rightMargin;
    }

    @Override
    public int getTopMargin() {
        return this.topMargin;
    }

    @Override
    public int getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    public boolean isTitleNewPage() {
        return this.isTitleNewPage;
    }

    @Override
    public boolean isSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    @Override
    public boolean isSummaryWithPageHeaderAndFooter() {
        return this.isSummaryWithPageHeaderAndFooter;
    }

    @Override
    public boolean isFloatColumnFooter() {
        return this.isFloatColumnFooter;
    }

    @Override
    public String getScriptletClass() {
        return this.mainDataset.getScriptletClass();
    }

    @Override
    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    @Override
    public String getResourceBundle() {
        return this.mainDataset.getResourceBundle();
    }

    @Override
    public String[] getPropertyNames() {
        return this.mainDataset.getPropertiesMap().getPropertyNames();
    }

    @Override
    public String getProperty(String propName) {
        return this.mainDataset.getPropertiesMap().getProperty(propName);
    }

    @Override
    public void setProperty(String propName, String value) {
        this.mainDataset.getPropertiesMap().setProperty(propName, value);
    }

    @Override
    public void removeProperty(String propName) {
        this.mainDataset.getPropertiesMap().removeProperty(propName);
    }

    @Override
    public String[] getImports() {
        if (this.importsSet != null) {
            return this.importsSet.toArray(new String[this.importsSet.size()]);
        }
        return null;
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public JRStyle[] getStyles() {
        return this.styles;
    }

    @Override
    public JRScriptlet[] getScriptlets() {
        return this.mainDataset.getScriptlets();
    }

    @Override
    public JRParameter[] getParameters() {
        return this.mainDataset.getParameters();
    }

    @Override
    public JRQuery getQuery() {
        return this.mainDataset.getQuery();
    }

    @Override
    public JRField[] getFields() {
        return this.mainDataset.getFields();
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.mainDataset.getSortFields();
    }

    @Override
    public JRVariable[] getVariables() {
        return this.mainDataset.getVariables();
    }

    @Override
    public JRGroup[] getGroups() {
        return this.mainDataset.getGroups();
    }

    @Override
    public JRBand getBackground() {
        return this.background;
    }

    @Override
    public JRBand getTitle() {
        return this.title;
    }

    @Override
    public JRBand getPageHeader() {
        return this.pageHeader;
    }

    @Override
    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    @Override
    public JRSection getDetailSection() {
        return this.detailSection;
    }

    @Override
    public JRBand getColumnFooter() {
        return this.columnFooter;
    }

    @Override
    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    @Override
    public JRBand getLastPageFooter() {
        return this.lastPageFooter;
    }

    @Override
    public JRBand getSummary() {
        return this.summary;
    }

    @Override
    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.mainDataset.getWhenResourceMissingTypeValue();
    }

    @Override
    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        this.mainDataset.setWhenResourceMissingType(whenResourceMissingType);
    }

    @Override
    public JRDataset getMainDataset() {
        return this.mainDataset;
    }

    @Override
    public JRDataset[] getDatasets() {
        return this.datasets;
    }

    @Override
    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    @Override
    public boolean hasProperties() {
        return this.mainDataset.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mainDataset.getPropertiesMap();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRReportTemplate[] getTemplates() {
        return this.templates;
    }

    @Override
    public JRBand getNoData() {
        return this.noData;
    }

    public JRBand[] getAllBands() {
        ArrayList<JRBand> bands = new ArrayList<JRBand>();
        this.addBand(this.title, bands);
        this.addBand(this.pageHeader, bands);
        this.addBand(this.columnHeader, bands);
        for (JRGroup group : this.mainDataset.getGroups()) {
            this.addBands(group.getGroupHeaderSection(), bands);
            this.addBands(group.getGroupFooterSection(), bands);
        }
        this.addBands(this.detailSection, bands);
        this.addBand(this.columnFooter, bands);
        this.addBand(this.pageFooter, bands);
        this.addBand(this.lastPageFooter, bands);
        this.addBand(this.summary, bands);
        this.addBand(this.noData, bands);
        return bands.toArray(new JRBand[bands.size()]);
    }

    private void addBand(JRBand band, List<JRBand> bands) {
        if (band != null) {
            bands.add(band);
        }
    }

    private void addBands(JRSection section, List<JRBand> bands) {
        if (section != null) {
            for (JRBand band : section.getBands()) {
                this.addBand(band, bands);
            }
        }
    }

    @Override
    public UUID getUUID() {
        return this.mainDataset.getUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseReport jRBaseReport = this;
        synchronized (jRBaseReport) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.detail != null) {
            this.detailSection = new JRBaseSection(this.detail);
            this.detail = null;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.whenNoDataTypeValue = WhenNoDataTypeEnum.getByValue(this.whenNoDataType);
            this.printOrderValue = PrintOrderEnum.getByValue(this.printOrder);
            this.orientationValue = OrientationEnum.getByValue(this.orientation);
        }
    }
}

