/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.actions.JrxmLookupListener;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class OpenFileAction
extends NodeAction {
    private static List jrxmlListeners = new ArrayList();

    public String getName() {
        return NbBundle.getMessage(OpenFileAction.class, (String)"CTL_OpenFileAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            final Node node = activatedNodes[i];
            final RepositoryFile rf = (RepositoryFile)((ResourceNode)node).getRepositoryObject();
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        String fname = rf.getFile();
                        DataObject obj = DataObject.find((FileObject)FileUtil.toFileObject((File)new File(fname)));
                        OpenCookie ocookie = (OpenCookie)obj.getCookie(OpenCookie.class);
                        if (ocookie != null) {
                            ocookie.open();
                            RepositoryReportUnit reportUnit = ReportUnitNode.getParentReportUnit(node);
                            if (reportUnit != null) {
                                JasperServerManager.getMainInstance().getJrxmlReportUnitMap().put(fname, reportUnit);
                            }
                            if (rf.getDescriptor().getWsType().equals("jrxml")) {
                                JrxmLookupListener listener = new JrxmLookupListener(obj, jrxmlListeners, reportUnit, rf.getServer());
                                jrxmlListeners.add(listener);
                            }
                        }
                    }
                    catch (Exception ex) {
                        final String msg = ex.getMessage();
                        Mutex.EVENT.readAccess(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{msg}));
                            }
                        });
                        ex.printStackTrace();
                    }
                }
            };
            Thread t = new Thread(run);
            t.start();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof ResourceNode)) {
                return false;
            }
            ResourceNode node = (ResourceNode)activatedNodes[i];
            if (node.getRepositoryObject() instanceof RepositoryFile) continue;
            return false;
        }
        return true;
    }
}

