/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.options;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.options.JasperServerRepositoryOptionsPanelController;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class JasperServerRepositoryPanel
extends JPanel {
    private final JasperServerRepositoryOptionsPanelController controller;
    private boolean init = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClearCertificatesCache;
    private JCheckBox jCheckBoxPreventChunkedRequests;
    private JCheckBox jCheckBoxProMode;
    private JCheckBox jCheckBoxTreeLabels;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton jRadioButtonDIME;
    private JRadioButton jRadioButtonMIME;
    private JSpinner jSpinner1;

    JasperServerRepositoryPanel(JasperServerRepositoryOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.jSpinner1.setModel(new SpinnerNumberModel(0, 0, 2147483, 5));
    }

    public boolean setInit(boolean b) {
        boolean old = this.init;
        this.init = b;
        return old;
    }

    public boolean isInit() {
        return this.init;
    }

    public void notifyChange() {
        if (this.controller != null && !this.isInit()) {
            this.controller.changed();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jCheckBoxProMode = new JCheckBox();
        this.jButtonClearCertificatesCache = new JButton();
        this.jCheckBoxPreventChunkedRequests = new JCheckBox();
        this.jRadioButtonDIME = new JRadioButton();
        this.jRadioButtonMIME = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jCheckBoxTreeLabels = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jLabel1.text"));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JasperServerRepositoryPanel.this.jSpinner1StateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxProMode, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jCheckBoxProMode.text"));
        this.jCheckBoxProMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JasperServerRepositoryPanel.this.jCheckBoxProModeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonClearCertificatesCache, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jButtonClearCertificatesCache.text"));
        this.jButtonClearCertificatesCache.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JasperServerRepositoryPanel.this.jButtonClearCertificatesCacheActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxPreventChunkedRequests, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jCheckBoxPreventChunkedRequests.text"));
        this.jCheckBoxPreventChunkedRequests.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JasperServerRepositoryPanel.this.jCheckBoxPreventChunkedRequestsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonDIME);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonDIME, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jRadioButtonDIME.text"));
        this.buttonGroup1.add(this.jRadioButtonMIME);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonMIME, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jRadioButtonMIME.text"));
        this.jRadioButtonMIME.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JasperServerRepositoryPanel.this.jRadioButtonMIMEActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxTreeLabels, (String)NbBundle.getMessage(JasperServerRepositoryPanel.class, (String)"JasperServerRepositoryPanel.jCheckBoxTreeLabels.text"));
        this.jCheckBoxTreeLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JasperServerRepositoryPanel.this.jCheckBoxTreeLabelsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonMIME).add((Component)this.jRadioButtonDIME))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSpinner1, -2, 82, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(2, 2, 2).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jCheckBoxPreventChunkedRequests, -1, 429, Short.MAX_VALUE).add((Component)this.jCheckBoxProMode, -1, 429, Short.MAX_VALUE))).add((Component)this.jLabel2).add((Component)this.jButtonClearCertificatesCache))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(22, 22, 22).add((Component)this.jCheckBoxTreeLabels, -1, 429, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jSpinner1, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(1).add((Component)this.jCheckBoxProMode).addPreferredGap(0).add((Component)this.jCheckBoxPreventChunkedRequests).add(26, 26, 26).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jRadioButtonMIME).addPreferredGap(1).add((Component)this.jRadioButtonDIME).add(18, 18, 18).add((Component)this.jButtonClearCertificatesCache).add(18, 18, 18).add((Component)this.jCheckBoxTreeLabels).addContainerGap(110, Short.MAX_VALUE)));
    }

    private void jCheckBoxProModeActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        this.notifyChange();
    }

    private void jButtonClearCertificatesCacheActionPerformed(ActionEvent evt) {
        JasperServerManager.getPreferences().remove("trustedCertificateFingerprints");
        JOptionPane.showMessageDialog(Misc.getMainFrame(), "All the trusted certificate fingerprints have been removed from the cache.");
    }

    private void jCheckBoxPreventChunkedRequestsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    private void jRadioButtonMIMEActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxTreeLabelsActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    void load() {
        this.setInit(true);
        int timeout = IReportManager.getPreferences().getInt("client_timeout", 0);
        this.jSpinner1.setValue(new Integer(timeout));
        this.jCheckBoxProMode.setSelected(IReportManager.getPreferences().getBoolean("proMode", false));
        this.jCheckBoxPreventChunkedRequests.setSelected(IReportManager.getPreferences().getBoolean("jasperserver.preventChunkedRequests", true));
        this.jCheckBoxTreeLabels.setSelected(IReportManager.getPreferences().getBoolean("jasperserver.showResourceIDs", false));
        this.jRadioButtonMIME.setSelected(IReportManager.getPreferences().getBoolean("jasperserver.useMIME", true));
        this.jRadioButtonDIME.setSelected(!this.jRadioButtonMIME.isSelected());
        this.setInit(false);
    }

    void store() {
        IReportManager.getPreferences().putInt("client_timeout", ((SpinnerNumberModel)this.jSpinner1.getModel()).getNumber().intValue());
        IReportManager.getPreferences().putBoolean("proMode", this.jCheckBoxProMode.isSelected());
        IReportManager.getPreferences().putBoolean("jasperserver.preventChunkedRequests", this.jCheckBoxPreventChunkedRequests.isSelected());
        IReportManager.getPreferences().putBoolean("jasperserver.showResourceIDs", this.jCheckBoxTreeLabels.isSelected());
        IReportManager.getPreferences().putBoolean("jasperserver.useMIME", this.jRadioButtonMIME.isSelected());
    }

    boolean valid() {
        return true;
    }
}

