/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.netbeans.modules.xml.retriever.impl.ResourceRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLResourceRetriever
implements ResourceRetriever {
    private static final String URI_SCHEME = "http";
    long streamLength = 0L;
    URL effectiveURL = null;

    @Override
    public boolean accept(String string, String string2) throws URISyntaxException {
        URI uRI;
        URI uRI2 = new URI(string2);
        if (uRI2.isAbsolute() && uRI2.getScheme().equalsIgnoreCase(URI_SCHEME)) {
            return true;
        }
        return string != null && !uRI2.isAbsolute() && (uRI = new URI(string)).getScheme().equalsIgnoreCase(URI_SCHEME);
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String string, String string2) throws IOException, URISyntaxException {
        String string3 = this.getEffectiveAddress(string, string2);
        if (string3 == null) {
            return null;
        }
        URI uRI = new URI(string3);
        HashMap<String, InputStream> hashMap = null;
        InputStream inputStream = this.getInputStreamOfURL(uRI.toURL(), ProxySelector.getDefault().select(uRI).get(0));
        hashMap = new HashMap<String, InputStream>();
        hashMap.put(this.effectiveURL.toString(), inputStream);
        return hashMap;
    }

    public InputStream getInputStreamOfURL(URL uRL, Proxy proxy) throws IOException {
        Object object;
        URLConnection uRLConnection = null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        uRLConnection = proxy != null ? uRL.openConnection(proxy) : uRL.openConnection();
        HttpURLConnection httpURLConnection = null;
        if (uRLConnection instanceof HttpURLConnection) {
            httpURLConnection = (HttpURLConnection)uRLConnection;
            HttpURLConnection.setFollowRedirects(false);
        }
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        uRLConnection.connect();
        while (true) {
            if (httpURLConnection.getResponseCode() != 302) {
                if (httpURLConnection.getResponseCode() != 301) break;
            }
            object = httpURLConnection.getHeaderField("Location");
            uRL = new URL((String)object);
            uRLConnection = proxy != null ? uRL.openConnection(proxy) : uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
                HttpURLConnection.setFollowRedirects(false);
            }
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            uRLConnection.connect();
        }
        uRLConnection.setReadTimeout(10000);
        object = uRLConnection.getInputStream();
        this.streamLength = uRLConnection.getContentLength();
        this.effectiveURL = uRLConnection.getURL();
        return object;
    }

    @Override
    public long getStreamLength() {
        return this.streamLength;
    }

    @Override
    public String getEffectiveAddress(String string, String string2) throws IOException, URISyntaxException {
        return URLResourceRetriever.resolveURL(string, string2);
    }

    public static String resolveURL(String string, String string2) throws URISyntaxException {
        URI uRI = new URI(string2);
        String string3 = null;
        if (uRI.isAbsolute()) {
            string3 = uRI.toString();
            return string3;
        }
        if (string != null) {
            URI uRI2 = new URI(string);
            URI uRI3 = uRI2.resolve(uRI);
            string3 = uRI3.toString();
            return string3;
        }
        return null;
    }
}

