/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.StartManager;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartAction
extends CookieAction {
    private static final Class[] COOKIE_CLASSES = new Class[]{DatabaseServer.class};

    public StartAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_StartAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(StartAction.class);
    }

    public boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        DatabaseServer databaseServer = (DatabaseServer)nodeArray[0].getCookie(DatabaseServer.class);
        if (databaseServer == null) {
            return false;
        }
        DatabaseServer.ServerState serverState = databaseServer.getState();
        return serverState != DatabaseServer.ServerState.CONNECTED && !StartManager.getDefault().isStartRequested();
    }

    protected void performAction(Node[] nodeArray) {
        DatabaseServer databaseServer = (DatabaseServer)nodeArray[0].getCookie(DatabaseServer.class);
        String string = databaseServer.getStartPath();
        String string2 = Utils.getMessage("MSG_NoStartPath", new Object[0]);
        PropertiesDialog propertiesDialog = new PropertiesDialog(databaseServer);
        while (string == null || string.equals("")) {
            if (!Utils.displayConfirmDialog(string2)) {
                return;
            }
            if (!propertiesDialog.displayDialog(PropertiesDialog.Tab.ADMIN)) {
                return;
            }
            string = databaseServer.getStartPath();
        }
        StartManager.getDefault().start(databaseServer);
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }
}

